<?php return array (
  'manifest-version' => '1.1',
  'manifest-attributes' => 
  array (
    'changelog' => 'Changelog for easyComm.

ВАЖНО: БЕКАП ПЕРЕД ОБНОВЛЕНИЕМ ОБЯЗАТЕЛЕН.
Прочитайте публикацию: https://modx.pro/components/24637

1.15.1-pl (03.02.2025)
==============
- Исправлена ошибка с отправкой уведомлений администратору
- Изменена область видимости easyCommReCaptchaCallback в js скрипте

1.15.0-pl (22.02.2024)
==============
- Добавлены ответы на сообщения (объект ecReply)
- Обновлен основной js файл в связи с новыми функциями
- Обновлены css стили и html разметка чанков. Старые стили доступны в файле ec_3.3.0.css
- Сниппет ecMessages: параметр tpl теперь отвечает за вывод всех сообщений сразу, чанк tpl.ecMessages.Row удален.
- Сниппет ecMessages: удалены параметры tplWrapper, tplEmpty, outputSeparator, toSeparatePlaceholders
- Сниппет ecMessages: новый параметр repliesEnable
- Обновлен чанк tpl.ecForm
- Новый сниппет ecReplyForm
- Поле properties объекта ecThread теперь хранит сведения о 2х сниппетах (ecForm и ecReplyForm)
- Продвинутый resolver структуры БД в инсталляторе
- defaultEngine для MySQL теперь InnoDB (вместо MyISAM)
- Переименованы поля ecThread (resource -> resource_id), ecMessage (thread -> thread_id), ecVote (message -> message_id)
- Переименованы timestamp поля объектов (напр. createdon => created_on)
- Изменена работа уведомлений через email, обновились соответствующие чанки и параметры сниппетов
- Удалена настройка ec_use_reply_templates
- Генерация превью для прикрепленных изображений
- Множество других мелких исправлений

1.14.0-pl (04.01.2024)
==============
- Три новые темы с векторными иконками для звездочек
- Заменены иконки на векторные в блоке голосования
- Новый параметр starsTheme для сниппетов ecForm, ecMessages, ecThreadRating
- Новый параметр algorithm для сниппета ecThreadRating
- Новый параметр starWidthAndGup для сниппета ecThreadRating

1.12.2-pl (28.12.2023)
==============
- Добавлен checkbox с согласием на обработку персональных данных в форму (параметр agreementCheckbox сниппета ecForm)
- Файлы ec.default.js и ec.default.css переименованы в ec.js и ec.css
- Скрипт ec.default.js (с использованием jQuery) более не поддерживается, переименован в ec.old.js.

1.12.1-pl (03.11.2023)
==============
- Исправлены ошибки в таблице сообщений, если связанный с цепочкой ресурс был удален

1.12.0-pl (18.09.2023)
==============
- Исправлена ошибка невозможности удаления своего голоса при голосовании
- Возможность прикреплять файлы к сообщениям в админке.

1.11.5-pl (31.10.2022)
==============
- Исправление для загрузки файлов при работе с облачными хранилищами

1.11.4-pl (15.02.2022)
==============
- Добавлена версия скриптов компонента без использования jQuery.
  Если у вас не используется jQuery и вы не хотите его подключать - укажите в настройках файл:
  /assets/components/easycomm/js/web/ec.js

1.11.3-pl (12.01.2022)
==============
- Добавлен параметр user для сниппета ecMessage
- Исправлен возможный баг при генерации имени загружаемого пользователями файла
- Исправлена возможная ошибка из-за разделителя дробной части в различных локалях путем форматирования с number_format

1.11.1-pl (27.04.2021)
==============
- Исправлена ошибка в работе параметров fileSize, filesCount сниппета ecForm

1.11.0-pl (22.04.2021)
==============
- Возможность прикреплять файлы к сообщениям (параметры files, fileTypes, fileSize, filesCount сниппета ecForm)

1.10.4-pl (23.05.2020)
==============
- Исправлена ошибка с неработающим параметром gravatarSize в сниппете ecMessages

1.10.3-pl (31.03.2020)
==============
- Исправлено появление WARN в панели управления из-за не указанного контекста в функции makeUrl
- Добавлена системная настройка ec_message_window_system_tabs

1.10.2-pl (24.12.2019)
==============
- Исправлена js ошибка при создании Сообщения из админки

1.10.1-pl (19.12.2019)
==============
- Новый permission ec_vote_remove
- Косметические улучшения в таблице голосов

1.10.0-pl (15.11.2019)
==============
- Возможность голосования за сообщения. Новый объект ecVote.

1.9.2-pl (27.05.2019)
==============
- Добавлен параметр validateEmail к сниппету ecForm. Указывает о необходимости проверки поля user_email на корректность введенного значения.

1.9.1-pl (01.04.2019)
==============
- Добавлен параметр itemReviewed к сниппету ecThreadRating для корректного формирования микроразметки (AggregateRating)

1.9.0-pl (06.03.2019)
==============
- Добавлена политика доступа easyCommPolicy
- Подстановка в шаблонные ответы полей сообщения, например "Добрый день, {$user_name}"

1.8.6-pl (04.02.2019)
==============
- Прямая ссылка на сообщение в письме менеджеру (через параметр ecmessage)
- Wysiwyg редактор в поле Ответ в панели управления (отключаемый)

1.8.5-pl (29.01.2019)
==============
- Возможность настраивать фильтры в списке сообщений в панели управления (настройка ec_message_grid_filters)
- Удалено modAction при создании меню

1.8.2-pl (21.01.2019)
==============
- Исправлено Nan в сниппете ecThreadRating (деление на 0)

1.8.1-pl (16.01.2019)
==============
- Добавлены шаблоны для быстрых ответов (системная настройка ec_use_reply_templates)

1.7.2-pl (09.01.2019)
==============
- Исправлена ошибка в сниппете ecThreadRating при вызове метода getVotes
- Изображение звездочек перенесено в css (base64)

1.7.0-pl (26.12.2018)
==============
- Добавлено отображение расширенного рейтинга в сниппете ecThreadRating
- Исправлена не работающая опция перезаписи чанков при обновлении компонента

1.6.0-pl (18.12.2018)
==============
- Добавлена поддержка в ядро компонента множественных полей рейтинга

1.5.2-pl (19.11.2018)
==============
- Уменьшена длина поля name у объекта ecThread, т.к. были проблемы с созданием индекса по полю на некоторых серверах
- Увеличена длина поля IP для возможности сохранения ipv6

1.5.1-pl (25.06.2018)
==============
- Микроразметка AggregateRating для сниппета ecThreadRating
- Исправлена ошибка в передаче параметров в ecMessages при работе через Fenom

1.5.0-pl (24.05.2018)
==============
- Перевод чанков на шаблонизатор Fenom
- Интегрирован механизм защиты дополнения
- Добавлена вкладка История в окне редактирования Сообщения
- Fix ширины поля с прикрепленным изображением
- Поддержка произвольного Media Source в easyComm.utils.renderImage (параметр source)

1.4.3-pl (19.07.2017)
==============
- Исправлено поведение сниппета ecThreadRating при отсутствующем в базе объекте ecThread
- Убрана лишняя инициализация pdoTools в сниппетах

1.4.2-pl (04.07.2017)
==============
- Значения по-умолчанию для некоторых полей сообщения (thread) и цепочки (resource, name) при создании из панели управления
- Возможность указать значение рейтинга по-умолчанию при создании нового сообщения в панели управления (просто создайте настройку ec_rating_default = X)

1.4.0-pl (19.06.2017)
==============
- Новый параметр messages у сниппета ecMessages, в котором можно указать id конкретных сообщений

1.3.3-pl (19.06.2017)
==============
- В тексте письма менеджеру адрес панели управления теперь берется из системных настроек

1.3.2-pl (29.05.2017)
==============
- Добавлена поддержка Google ReCaptcha v2 для защиты от спама

1.3.1-pl (17.03.2017)
==============
- Графическое отображение рейтинга в админке, с возможностью отключения

1.3.0-pl (25.01.2017)
==============
- Добавлен en лексикон (спасибо Grigoriy Kolenko)
- Переключение контекста при запросах к action.php
- idx в сниппете ecMessages теперь привязан к idx от pdoTools, нумерация идет с 1, а не с 0
- Процессоры редактирования/удаления объектов теперь наследуются от modObjectUpdateProcessor и modObjectRemoveProcessor
- Добавлены события OnBeforeEcThreadRemove и OnEcThreadRemove

1.2.9-pl (19.01.2017)
==============
- Исправлена ошибка с пользовательским leftJoin в ecMessages

1.2.8-pl
==============
- Отключена перезапись чанков в скрипте установки
- Добавлен параметр resourceFields в сниппет ecMessages

1.2.7-pl
==============
- Добавлен параметр mailManager к сниппету ecForm

1.2.6-pl
==============
- Добавлена колонка Ресурс в списке сообщений в панели управления

1.2.5-pl
==============
- Поддержка Gravatar в сниппете ecMessages

1.2.4-pl
==============
- В сниппете ecForm для отоборажения чанка формы теперь используется $pdoTools
- Исправлена критическая ошибка при указании параметра tplWrapper в сниппете ecMessages
- Добавлена функция "Посмотреть сообщение на сайте" в административной части

1.2.3-pl1
==============
- Исправлен баг при использовании tplWrapper, связанный с передачей данных в чанк, где фигурировала переменная $thread

1.2.3-pl
==============
- Добавлен сниппет ecMessagesCount

1.2.2-pl
==============
- Добавлен параметр $threads к сниппету ecMessages, позволяющий выводить сообщения из нескольких цепочек

1.2.1-pl
==============
- Добавлена настройка auto_reply_author - автоматическое заполнение поля Автор ответа

1.2.0-pl
==============
- Добавлены вспомогательные методы в utils.js для работы с дополнительными полями-изображениями
- События на действия с сообщениями для возможности написания плагинов

1.1.3-pl
==============
- Добавлен параметр tplEmpty к сниппету cMessages

1.1.2-pl
==============
- Ошибка с непрописанным formId в html
- Замена $ на jQuery для избежания проблем с jQuery.noConflict()

1.1.1-pl
==============
- Возможность автопубликации сообщений
- Поддержка авторизованных пользователей в сниппете ecForm

1.1.0-pl
==============
- Устранена ошибка при редактировании цепочки сообщений

1.1.0-beta
==============
- Исправлено форматирование даты в окне редактирования сообщения
- Возврат потерянного поля thread_name в списке сообщений

1.1.0-beta
==============
- Возможность настройки отображения списка колонок при просмотре списка сообщений и цепочек сообщений
- Возможность настройки отображение разметки окна редактировани сообщения и цепочки
- Интегрирована система плагинов для добавления полей сообщениям (ecMessage)

1.0.4-beta2
==============
- Добавлено поле IP адрес к объекту ecMessage
- Добавлена Оценка к Сообщениям
- Автоматический подсчет средней Оценки для Цепочки по 2-м алгоритмам: Средняя и Вильсон

1.0.2-beta1
==============
- Исправлена критическая ошибка, возникающая при установке пакета

1.0.0-beta
==============
- First version',
    'license' => 'GNU GENERAL PUBLIC LICENSE
   Version 2, June 1991
--------------------------

Copyright (C) 1989, 1991 Free Software Foundation, Inc.
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Everyone is permitted to copy and distribute verbatim copies
of this license document, but changing it is not allowed.

Preamble
--------

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation\'s software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author\'s protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors\' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone\'s free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.


GNU GENERAL PUBLIC LICENSE
TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
---------------------------------------------------------------

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program\'s
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients\' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

NO WARRANTY
-----------

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

---------------------------
END OF TERMS AND CONDITIONS',
    'readme' => '--------------------
easyComm
--------------------
Author: Alexey Naumov <alexei@createit.ru>
--------------------

Компонент предназначен для создания на сайтах таких модулей, как отзывы, комментарии, вопросы пользователей.

Название easyComm произошло от Easy Communication, или Easy Comments, кому как больше нравится.

Компонент позволяет пользователям сайта через специальную форму оставить свое сообщение/отзыв/вопрос,
а администратор увидит их в панели управления сайтом, сможет опубликовать сообщение,
удалить его или оставить свой ответ.',
    'chunks' => 
    array (
      'tpl.ecForm' => '<h2>{\'ec_fe_message_add\' | lexicon}</h2>
<form class="form well ec-form" method="post" role="form" id="{$fid}" action="" {if $files}formenctype="multipart/form-data"{/if}>
    <input type="hidden" name="thread" value="{$thread}">
    <input type="hidden" name="MAX_FILE_SIZE" value="{\'upload_maxsize\'|option}">

    <div class="ec-form__row ec-antispam">
        <label for="{$fid}-{$antispam_field}" class="control-label">{\'ec_fe_message_antismap\' | lexicon}</label>
        <input type="text" name="{$antispam_field}" class="form-control" id="{$fid}-{$antispam_field}" value="" />
    </div>

    <div class="ec-form__row ec-input-parent">
        <label for="{$fid}-user_name" class="control-label">{\'ec_fe_message_user_name\' | lexicon}</label>
        <input type="text" name="user_name" class="form-control" id="{$fid}-user_name" value="{$user_name}" />
        <span class="ec-error help-block" id="{$fid}-user_name-error"></span>
    </div>

    <div class="ec-form__row ec-input-parent">
        <label for="{$fid}-user_email" class="control-label">{\'ec_fe_message_user_email\' | lexicon}</label>
        <input type="text" name="user_email" class="form-control" id="{$fid}-user_email" value="{$user_email}" />
        <span class="ec-error help-block" id="{$fid}-user_email-error"></span>
    </div>

    <div class="ec-form__row ec-input-parent">
        <label for="{$fid}-user_contacts" class="control-label">{\'ec_fe_message_user_contacts\' | lexicon}</label>
        <input type="text" name="user_contacts" class="form-control" id="{$fid}-user_contacts" value="{$user_contacts}" />
        <span class="ec-error help-block" id="{$fid}-user_contacts-error"></span>
    </div>

    <div class="ec-form__row ec-input-parent">
        <label for="{$fid}-subject" class="control-label">{\'ec_fe_message_subject\' | lexicon}</label>
        <input type="text" name="subject" class="form-control" id="{$fid}-subject" value="{$subject}" />
        <span class="ec-error help-block" id="{$fid}-subject-error"></span>
    </div>

    <div class="ec-form__row ec-input-parent">
        <label for="{$fid}-rating" class="control-label">{\'ec_fe_message_rating\' | lexicon}</label>
        <input type="hidden" name="rating" id="{$fid}-rating" value="{$rating}" />
        <div class="ec-rating ec-clearfix" data-storage-id="{$fid}-rating">
            <div class="ec-rating-stars ec-rating-stars--{$stars_theme}">
                <span data-rating="1" data-description="{\'ec_fe_message_rating_1\' | lexicon}"></span>
                <span data-rating="2" data-description="{\'ec_fe_message_rating_2\' | lexicon}"></span>
                <span data-rating="3" data-description="{\'ec_fe_message_rating_3\' | lexicon}"></span>
                <span data-rating="4" data-description="{\'ec_fe_message_rating_4\' | lexicon}"></span>
                <span data-rating="5" data-description="{\'ec_fe_message_rating_5\' | lexicon}"></span>
            </div>
            <div class="ec-rating-description">{\'ec_fe_message_rating_0\' | lexicon}</div>
        </div>
        <span class="ec-error help-block" id="{$fid}-rating-error"></span>
    </div>

    <div class="ec-form__row ec-input-parent">
        <label for="{$fid}-text" class="control-label">{\'ec_fe_message_text\' | lexicon}</label>
        <textarea name="text" class="form-control" rows="5" id="{$fid}-text">{$text}</textarea>
        <span class="ec-error help-block" id="{$fid}-text-error"></span>
    </div>

    {if $files}
        <div class="ec-form__row ec-input-parent">
            <label for="{$fid}-files" class="control-label">{\'ec_fe_message_files\' | lexicon}</label>
            <input type="file" name="files[]" id="{$fid}-files" multiple="multiple" >
            <span class="ec-error help-block" id="{$fid}-files-error"></span>
        </div>
    {/if}

    {$recaptcha}

    {if $agreementCheckbox}
        <div class="ec-form__row checkbox ec-input-parent">
            <label>
                <input type="checkbox" name="agree" value="1"> {\'ec_fe_agree\' | lexicon}
            </label>
        </div>
    {/if}

    <div class="ec-form__row">
        <input type="submit" class="btn btn-primary" name="send" value="{\'ec_fe_send\' | lexicon}" />
    </div>
</form>
<div id="{$fid}-success"></div>',
      'tpl.ecForm.ReCaptcha' => '<div class="ec-form__row">
    <div class="ec-captcha" id="{$fid}-captcha"></div>
    <span class="ec-error help-block" id="{$fid}-captcha-error"></span>
</div>',
      'tpl.ecForm.Success' => '<div class="ec-message">
    {if $published}
        <div class="ec-alert">{\'ec_fe_send_success_published\' | lexicon}</div>
    {else}
        <div class="ec-alert">{\'ec_fe_send_success_unpublished\' | lexicon}</div>
    {/if}
    <div class="ec-message__header">
        <div class="ec-message__meta">
            <span class="ec-message__author">{$user_name}</span>
            <span class="ec-message__date">{$date | dateAgo}</span>
        </div>
    </div>
    <div class="ec-stars ec-stars--{$stars_theme}">
        <span class="rating-{$rating}"></span>
    </div>
    <p>{$text}</p>
    {if $files?}
        <div class="ec-message__files">
            {foreach $files as $file}
                {if $file[\'thumb_url\']?}
                    <a href="{$file[\'url\']}" target="_blank" class="ec-message__files-item ec-file ec-file--thumb">
                        <img src="{$file[\'thumb_url\']}" alt="{$file[\'title\']}" title="{$file[\'title\']}">
                    </a>
                {else}
                    <a href="{$file[\'url\']}" target="_blank" class="ec-message__files-item ec-file">
                        <div class="ec-file__name">{$file[\'title\']}</div>
                        <div class="ec-file__meta">{$file[\'extension\'] | upper} - {$file[\'size_str\']}</div>
                    </a>
                {/if}
            {/foreach}
        </div>
    {/if}
</div>',
      'tpl.ecReplyForm' => '<form class="ec-reply-form ec-d-none" method="post" role="form" id="{$fid}" action="">
    <input type="hidden" name="thread" value="{$thread}">
    <input type="hidden" name="message_id" value="">
    <input type="hidden" name="parent_id" value="">

    <div class="ec-reply-form__row ec-antispam">
        <label for="{$fid}-{$antispam_field}">{\'ec_fe_message_antismap\' | lexicon}</label>
        <input type="text" name="{$antispam_field}" class="form-control" id="{$fid}-{$antispam_field}" value="" />
        <span class="ec-error help-block ec-d-none" id="{$fid}-{$antispam_field}-error"></span>
    </div>

    <div class="ec-reply-form__row ec-input-parent">
        <label for="{$fid}-text">{\'ec_fe_reply\' | lexicon}:</label>
        <textarea name="text" class="form-control" rows="3" id="{$fid}-text">{$text}</textarea>
        <span class="ec-error help-block ec-d-none" id="{$fid}-text-error"></span>
    </div>

    <div class="ec-reply-form__row ec-form__cols">
        <div class="ec-reply-form__col ec-input-parent">
            <label for="{$fid}-user_name">{\'ec_fe_message_user_name\' | lexicon}</label>
            <input type="text" name="user_name" class="form-control" id="{$fid}-user_name" value="{$user_name}" />
            <span class="ec-error help-block ec-d-none" id="{$fid}-user_name-error"></span>
        </div>
        <div class="ec-reply-form__col ec-input-parent">
            <label for="{$fid}-user_email">{\'ec_fe_message_user_email\' | lexicon}</label>
            <input type="text" name="user_email" class="form-control" id="{$fid}-user_email" value="{$user_email}" />
            <span class="ec-error help-block ec-d-none" id="{$fid}-user_email-error"></span>
        </div>
    </div>

    {$recaptcha}

    {if $agreementCheckbox}
        <div class="ec-reply-form__row ec-input-parent checkbox">
            <label>
                <input type="checkbox" name="agree" value="1"> {\'ec_fe_agree\' | lexicon}
            </label>
        </div>
    {/if}

    <div class="ec-reply-form__row">
        <input type="submit" class="btn btn-primary" name="send" value="{\'ec_fe_send\' | lexicon}" />
        <button type="button" class="btn btn-link js-ec-reply-form-cancel" name="cancel">Отмена</button>
    </div>
</form>',
      'tpl.ecReplyForm.Success' => '<div class="ec-reply">
    {if $published}
        <div class="ec-alert">Ваш ответ опубликован</div>
    {else}
        <div class="ec-alert">Ваш ответ будет опубликован после одобрения модератором</div>
    {/if}
    <div class="ec-reply__header">
        <div class="ec-reply__meta">
            <span class="ec-reply__author">{$user_name}</span>
            <span class="ec-reply__date">{$created_on | dateAgo}</span>
        </div>
    </div>
    <p>
        {$text}
    </p>
</div>',
      'tpl.ecMessages' => '{if $messages?}
    {foreach $messages as $message}
        <div id="ec-{$message[\'thread_name\']}-message-{$message[\'id\']}" class="ec-message">
            <div class="ec-message__header">
                <div class="ec-message__meta">
                    <span class="ec-message__author">{$message[\'user_name\']}</span>
                    <span class="ec-message__date">{$message[\'date\'] | dateAgo}</span>
                </div>
                {if $message[\'voting_enable\']?}
                    {set $voting_button_classes = $message[\'voting_can_vote\'] ? \'js-ec-vote-button enabled\' : \'\'}
                    <div class="ec-message__votes" data-message-id="{$message[\'id\']}" data-properties-key="{$message[\'properties_key\']}">
                        <div class="ec-message__votes-item">
                            <a href="javascript:void(0)" class="{$voting_button_classes} ec-message__votes-button ec-message__votes-button-like {if $message[\'vote\']==1}active{/if}" data-value="1">
                                {$message[\'likes\']}
                            </a>
                        </div>
                        <div class="ec-message__votes-item">
                            <a href="javascript:void(0)" class="{$voting_button_classes} ec-message__votes-button ec-message__votes-button-dislike {if $message[\'vote\']==-1}active{/if}" data-value="-1">
                                {$message[\'dislikes\']}
                            </a>
                        </div>
                        <div class="ec-message__votes-bar"><span class="js-ec-vote-bar" style="width: {$message[\'votes_rating_percent\']}%"></span></div>
                    </div>
                {/if}
            </div>
            <div class="ec-stars ec-stars--{$message[\'stars_theme\']}">
                <span class="rating-{$message[\'rating\']}"></span>
            </div>
            <p>{$message[\'text\']}</p>
            {if $message[\'reply_text\']?}
                <div class="ec-message__reply">
                    <p>
                        {if $message[\'reply_author\']}
                            <strong>{$message[\'reply_author\']}:</strong>
                        {/if}
                        {$message[\'reply_text\']}
                    </p>
                </div>
            {/if}
            {if $message[\'files\']?}
                <div class="ec-message__files">
                    {foreach $message[\'files\'] as $file}
                        {if $file[\'thumb_url\']?}
                        <a href="{$file[\'url\']}" target="_blank" class="ec-message__files-item ec-file ec-file--thumb">
                            <img src="{$file[\'thumb_url\']}" alt="{$file[\'title\']}" title="{$file[\'title\']}">
                        </a>
                        {else}
                        <a href="{$file[\'url\']}" target="_blank" class="ec-message__files-item ec-file">
                            <div class="ec-file__name">{$file[\'title\']}</div>
                            <div class="ec-file__meta">{$file[\'extension\'] | upper} - {$file[\'size_str\']}</div>
                        </a>
                        {/if}
                    {/foreach}
                </div>
            {/if}
            {if $message[\'replies_enable\']?}
                <div class="ec-message__footer">
                    <a class="ec-message__footer-link js-ec-reply" href="javascript:void(0)"
                       data-ec-thread="{$message[\'thread_name\']}"
                       data-ec-message="{$message[\'id\']}">{\'ec_fe_reply\' | lexicon}</a>
                </div>
            {/if}
        </div>
        {if $message[\'replies\']?}
            {foreach $message[\'replies\'] as $reply}
                <div id="ec-{$message[\'thread_name\']}-reply-{$reply[\'id\']}" class="ec-reply">
                    <div class="ec-reply__header">
                        <div class="ec-reply__meta">
                            <span class="ec-reply__author">{$reply[\'user_name\']}</span>
                            <span class="ec-reply__date">{$reply[\'created_on\'] | dateAgo}</span>
                        </div>
                    </div>
                    <p>
                        {$reply[\'text\']}
                    </p>
                    {if $message[\'replies_enable\']?}
                        <div class="ec-reply__footer">
                            <a class="ec-reply__footer-link js-ec-reply" href="javascript:void(0)"
                               data-ec-thread="{$message[\'thread_name\']}"
                               data-ec-message="{$message[\'id\']}"
                               data-ec-parent="{$reply[\'id\']}">{\'ec_fe_reply\' | lexicon}</a>
                        </div>
                    {/if}
                </div>
            {/foreach}
        {/if}
    {/foreach}
{/if}',
      'tpl.ecThreadRating' => '<div class="ec-stars ec-stars--{$stars_theme}" title="{$rating}" itemscope itemtype="http://schema.org/AggregateRating">
    <meta itemprop="itemReviewed" content="{($itemReviewed ?: $_modx->resource[\'pagetitle\']) | e}" />
    <meta itemprop="ratingValue" content="{$rating}" />
    <meta itemprop="bestRating" content="{$rating_max}" />
    <meta itemprop="worstRating" content="1" />
    <meta itemprop="ratingCount" content="{$count}" />
    <span style="width: {$rating_percent}%"></span>
</div>',
      'tpl.ecThreadDetailedRating' => '<div class="ec-d-rating">
    <div class="ec-d-rating__col-info">
        <div class="ec-d-rating__value">
            {$rating | number : 2 : \',\' : \' \'}
        </div>
        <div class="ec-d-rating__stars">
            <div class="ec-stars ec-stars--{$stars_theme}" title="{$rating}" itemscope itemtype="http://schema.org/AggregateRating">
                <meta itemprop="itemReviewed" content="{($itemReviewed ?: $_modx->resource[\'pagetitle\']) | e}" />
                <meta itemprop="ratingValue" content="{$rating}" />
                <meta itemprop="bestRating" content="{$rating_max}" />
                <meta itemprop="worstRating" content="1" />
                <meta itemprop="ratingCount" content="{$count}" />
                <span style="width: {$rating_percent}%"></span>
            </div>
        </div>
        <div class="ec-d-rating__desc">
            {\'ec_fe_detailed_rating_desc\' | lexicon} &ndash; <strong>{$count}</strong>
        </div>
    </div>
    <div class="ec-d-rating__col-lines">
        <div class="ec-d-rating__lines">
            {foreach $rating_votes as $rate => $line}
                <div class="ec-d-rating__line">
                    <div class="ec-d-rating__line-rate">{$rate}</div>
                    <div class="ec-d-rating__line-progress"><span style="width:{$line[\'volume\']}%"></span></div>
                    <div class="ec-d-rating__line-volume">{$line[\'volume\'] | number}%</div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
',
      'tpl.ecForm.Email.Manager' => 'Новое сообщение на странице
<a target="_blank" href="{$resource.id | url : [\'scheme\' => \'full\']}">{$resource.pagetitle}</a>
от <span style="font-weight: bold">{$user_name}</span>{if $user_email} (<a href="mailto:{$user_email}">{$user_email}</a>){/if}:
<br />
<br />
<div style="white-space:pre;background: #f8f8f8;padding: 10px 15px;">{$text}</div>
<br />
{if $user_contacts}Контактная информация: <span style="font-weight: bold">{$user_contacts}</span><br/>{/if}
{if $subject}Тема сообщения: <span style="font-weight: bold">{$subject}</span><br/>{/if}
{if $rating}Оценка: <span style="font-weight: bold">{$rating}</span><br/>{/if}
<br />
<a target="_blank" href="{$site_manager_url}?a=resource/update&id={$resource.id}&ecmessage={$id}">Управление &gt;&gt;</a>
<br />
<br />
{if $files}
    <span style="font-weight: bold;">Прикрепленные файлы ({$files_count}):</span><br />

    {foreach $files as $file}
        {$file@index + 1}. <a href="{\'site_url\' | option}{$file[\'url\']}" target="_blank">{$file[\'name_original\']}</a><br />
    {/foreach}
{/if}',
      'tpl.ecForm.Email.User' => 'Здравствуйте, {$user_name}!
<br />
Вы оставляли сообщение на странице
<a href="{$resource.id | url : [\'scheme\' => \'full\']}">{$resource.pagetitle}</a>:
<br />
<br />
<div style="white-space:pre;background: #f0f0f0;padding: 10px;border: solid 1px #eee;">{$text}</div>
<br /><br />
{if $reply_text}
    {if $reply_author}
        <span style="font-weight:bold;">{$reply_author}</span> ответил на ваше сообщение:
    {else}
        На ваше сообщение дан ответ:
    {/if}
    <br />
    <br />
    <div style="white-space:pre;background: #f8f8f8;padding: 10px 15px;">{$reply_text}</div>
{/if}
{if $published}
    Ваше сообщение опубликовано <a href="{$resource.id | url : [\'scheme\' => \'full\']}#message-{$id}">здесь</a>.
{/if}
<br />
--
<br />
С уважением, {\'site_name\' | option}.',
      'tpl.ecReplyForm.Email.Manager' => 'Новый ответ на сообщение на странице
<a target="_blank" href="{$resource.id | url : [\'scheme\' => \'full\']}">{$resource.pagetitle}</a>
от <span style="font-weight: bold">{$user_name}</span>{if $user_email} (<a href="mailto:{$user_email}">{$user_email}</a>){/if}:
<br />
<br />
<div style="white-space:pre;background: #f8f8f8;padding: 10px 15px;">{$text}</div>
<br />
<br />
<a target="_blank" href="{$site_manager_url}?a=resource/update&id={$resource.id}&ecreply={$id}">Управление &gt;&gt;</a>
<br />',
      'tpl.ecReplyForm.Email.User' => 'Здравствуйте, {$user_name}!
<br />
{if $reply}
    Вам ответил пользователь <span style="font-weight: bold">{$reply.user_name}</span> на странице
    <a target="_blank" href="{$resource.id | url : [\'scheme\' => \'full\']}">{$resource.pagetitle}</a>:
    <br />
    <br />
    <div style="white-space:pre;background: #f8f8f8;padding: 10px 15px;">{$reply.text}</div>
{else}
    Ваш ответ на странице
    <a target="_blank" href="{$resource.id | url : [\'scheme\' => \'full\']}">{$resource.pagetitle}</a>
    опубликован:
    <br />
    <br />
    <div style="white-space:pre;background: #f8f8f8;padding: 10px 15px;">{$text}</div>
{/if}
<br />
--
<br />
С уважением, {\'site_name\' | option}.',
    ),
    'setup-options' => 'easycomm-1.15.1-pl/setup-options.php',
  ),
  'manifest-vehicles' => 
  array (
    0 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modNamespace',
      'guid' => 'e144bb75b401f4a5d2a476de51a8f85e',
      'native_key' => 'easycomm',
      'filename' => 'modNamespace/150c8109d2b7033a5f594948d1f33ecd.vehicle',
      'namespace' => 'easycomm',
    ),
    1 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOFileVehicle',
      'class' => 'xPDOFileVehicle',
      'guid' => '14c31833df0d2715cffc95c7368d10fb',
      'native_key' => '14c31833df0d2715cffc95c7368d10fb',
      'filename' => 'xPDOFileVehicle/7a0c622cf75841421645d37f4952c625.vehicle',
    ),
    2 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modAccessPolicy',
      'guid' => 'f66d56f8b1e0567698ff569d1f8de122',
      'native_key' => NULL,
      'filename' => 'modAccessPolicy/52fc5f2cde8f0d57d27655978cb9ab25.vehicle',
      'namespace' => 'easycomm',
    ),
    3 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modAccessPolicyTemplate',
      'guid' => '4ebe0ad2cb67cae631f66f9928219170',
      'native_key' => NULL,
      'filename' => 'modAccessPolicyTemplate/6f9ffd683d101b5799d9527e70ee2cc7.vehicle',
      'namespace' => 'easycomm',
    ),
    4 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'EncryptedVehicle',
      'class' => 'modCategory',
      'guid' => '09dd4496fed07b9e938857113603f669',
      'native_key' => NULL,
      'filename' => 'modCategory/a9171b58dabd80b02a6dd622e63a0cb7.vehicle',
      'namespace' => 'easycomm',
    ),
    5 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'b6b5ac16fbf0fbbbb289ef39ac708900',
      'native_key' => 'ec_show_templates',
      'filename' => 'modSystemSetting/64d77958b878b4884f5ba764528f8348.vehicle',
      'namespace' => 'easycomm',
    ),
    6 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '2a738195f37c56bf8f6cf76c23086892',
      'native_key' => 'ec_show_resources',
      'filename' => 'modSystemSetting/c9d2815611c3ab03ab3e0cc43341c228.vehicle',
      'namespace' => 'easycomm',
    ),
    7 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'eed809b74d63b31c49b88d1d4a36194b',
      'native_key' => 'ec_frontend_css',
      'filename' => 'modSystemSetting/8041d13b9474ce8ee734b0c440c7982b.vehicle',
      'namespace' => 'easycomm',
    ),
    8 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'c923574fd63a30f1199c29f82214403a',
      'native_key' => 'ec_frontend_js',
      'filename' => 'modSystemSetting/756914dae5021ab31997db9ebc6e4d98.vehicle',
      'namespace' => 'easycomm',
    ),
    9 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '12d761385a8d6ee885643789abf8c862',
      'native_key' => 'ec_thread_grid_fields',
      'filename' => 'modSystemSetting/eb977a7deab9355cd05b8d2b41f00594.vehicle',
      'namespace' => 'easycomm',
    ),
    10 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '28d23f61c8c34b04520af51c8539b632',
      'native_key' => 'ec_thread_window_fields',
      'filename' => 'modSystemSetting/92aca1103dfe3492a73c0acbc9dd56b5.vehicle',
      'namespace' => 'easycomm',
    ),
    11 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '53a256960e22f2373aaa4917327defbd',
      'native_key' => 'ec_use_rte',
      'filename' => 'modSystemSetting/25dba2f3a88608ad092ca814122631e4.vehicle',
      'namespace' => 'easycomm',
    ),
    12 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '1c9c12746db69261bb3bd3584966b1a6',
      'native_key' => 'ec_message_grid_fields',
      'filename' => 'modSystemSetting/1d7e62d4c8eb97661f45a094c631558a.vehicle',
      'namespace' => 'easycomm',
    ),
    13 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'ae81e7a72a13dad6c77c28d4e2b8e144',
      'native_key' => 'ec_message_window_layout',
      'filename' => 'modSystemSetting/d660ab6d58dad88cd476cf9a82cdc2dd.vehicle',
      'namespace' => 'easycomm',
    ),
    14 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '6d702a2da6035a8ef2452185bc8245df',
      'native_key' => 'ec_message_window_system_tabs',
      'filename' => 'modSystemSetting/b0aca191c19054640f55d4ec9ae619cd.vehicle',
      'namespace' => 'easycomm',
    ),
    15 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'f8fcbcb26caf93d963c5e2cb5cb2edba',
      'native_key' => 'ec_message_grid_filters',
      'filename' => 'modSystemSetting/e4d9b5e5dd0566966911c887025625bd.vehicle',
      'namespace' => 'easycomm',
    ),
    16 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'beb1d573ad6c956bfa2dfe492f59fd39',
      'native_key' => 'ec_auto_reply_author',
      'filename' => 'modSystemSetting/731232e0e46a1201e250935d1cb73460.vehicle',
      'namespace' => 'easycomm',
    ),
    17 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '5711aa19f9cbbe7c9a3ee092d891ed32',
      'native_key' => 'ec_files_source',
      'filename' => 'modSystemSetting/d9b256cfcf2ae5bde5f0fe958810b8f6.vehicle',
      'namespace' => 'easycomm',
    ),
    18 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '6ee016fb8ebea4bf934f9b18a0c9206c',
      'native_key' => 'ec_files_path',
      'filename' => 'modSystemSetting/1876c405a1bbd64d5b5e0fa1267b5da9.vehicle',
      'namespace' => 'easycomm',
    ),
    19 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '629169eb6654f8c43fc56f1507b489fe',
      'native_key' => 'ec_mail_notify_user',
      'filename' => 'modSystemSetting/a3634bde6f1b8a0ae12b67a5c6e7aa99.vehicle',
      'namespace' => 'easycomm',
    ),
    20 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '5414837aedf63e532ddc33cc4ea39caa',
      'native_key' => 'ec_mail_notify_manager',
      'filename' => 'modSystemSetting/1f37ce3ccb4e53c64c52819898cf4e87.vehicle',
      'namespace' => 'easycomm',
    ),
    21 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'c395d60cb547c6814dad96b4aa45b958',
      'native_key' => 'ec_mail_subject_manager',
      'filename' => 'modSystemSetting/433b3cd876f65f2bc09e33763f40bf5e.vehicle',
      'namespace' => 'easycomm',
    ),
    22 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '247823a7bd86f511e4cfdd1014545ecc',
      'native_key' => 'ec_mail_subject_user',
      'filename' => 'modSystemSetting/8686276cf821d82a54e421f9e3e303ff.vehicle',
      'namespace' => 'easycomm',
    ),
    23 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'cd9d451d3192780bfdf94283e4f7a24a',
      'native_key' => 'ec_mail_manager',
      'filename' => 'modSystemSetting/253cb82435697fbf4e741bf3059a7af4.vehicle',
      'namespace' => 'easycomm',
    ),
    24 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '9897d3e99d2c24a04a779455bb126933',
      'native_key' => 'ec_mail_from',
      'filename' => 'modSystemSetting/d8302b4350b08d68c6d314489c60e2be.vehicle',
      'namespace' => 'easycomm',
    ),
    25 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '8da396ad322a9bd1a9741b3db1acb997',
      'native_key' => 'ec_mail_from_name',
      'filename' => 'modSystemSetting/2bb00132db9c44c1baffdb74b50a0ec5.vehicle',
      'namespace' => 'easycomm',
    ),
    26 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'a63d7b990fd327129a012652a06ddb40',
      'native_key' => 'ec_rating_max',
      'filename' => 'modSystemSetting/e07916b822951592ec7f1176e8b775dd.vehicle',
      'namespace' => 'easycomm',
    ),
    27 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'a1c05e9c2eeaf715f39f94a22920a9e0',
      'native_key' => 'ec_rating_wilson_confidence',
      'filename' => 'modSystemSetting/d6fefac723125d48786cadd4ac398f72.vehicle',
      'namespace' => 'easycomm',
    ),
    28 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'e2d50fa24b3f45dc192909e3684bf6fd',
      'native_key' => 'ec_rating_visual_editor',
      'filename' => 'modSystemSetting/c43bbf4e6db849c24d00c64571927511.vehicle',
      'namespace' => 'easycomm',
    ),
    29 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '55de7720fdcd6601cfc54350a008c3b1',
      'native_key' => 'ec_gravatar_size',
      'filename' => 'modSystemSetting/1ec3808fcfdf691b059c35389e60190a.vehicle',
      'namespace' => 'easycomm',
    ),
    30 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'a2b6064f60ed86676b280b8071f59296',
      'native_key' => 'ec_gravatar_default',
      'filename' => 'modSystemSetting/5ae0bb94fd595f30e7131d83593b049f.vehicle',
      'namespace' => 'easycomm',
    ),
    31 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '46b4f46c4f3c691d3a69c17b488d6ced',
      'native_key' => 'ec_captcha_enable',
      'filename' => 'modSystemSetting/ee009595de21fccec8d88cfcdb072007.vehicle',
      'namespace' => 'easycomm',
    ),
    32 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '696b2a06bca0e67eec47c5531e3c5465',
      'native_key' => 'ec_recaptcha2_api',
      'filename' => 'modSystemSetting/196c022987c3deaf9d2deecfda5a1cb9.vehicle',
      'namespace' => 'easycomm',
    ),
    33 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'd95079cac8b5b0f01a80a32a9ef7da2a',
      'native_key' => 'ec_recaptcha2_site_key',
      'filename' => 'modSystemSetting/d7c50516a46d9d46753d5ccc20a03534.vehicle',
      'namespace' => 'easycomm',
    ),
    34 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'fd71c0dec24da71085fb8550e04fa28e',
      'native_key' => 'ec_recaptcha2_secret_key',
      'filename' => 'modSystemSetting/03359572d5aa6c984233af49a1646eb2.vehicle',
      'namespace' => 'easycomm',
    ),
    35 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '7991013d7e84b40bdbe6042a366eef69',
      'native_key' => 'OnBeforeEcThreadRemove',
      'filename' => 'modEvent/0267a5915c4e293be667d214623dd181.vehicle',
      'namespace' => 'easycomm',
    ),
    36 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => 'ae5a1833766979b270beaeb81c73cd70',
      'native_key' => 'OnEcThreadRemove',
      'filename' => 'modEvent/55232df9d778dbbc21a7010869533a9f.vehicle',
      'namespace' => 'easycomm',
    ),
    37 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => 'eb93b126c9dd5fcef5f0af71924886ab',
      'native_key' => 'OnBeforeEcMessageSave',
      'filename' => 'modEvent/43c44e6c872a501637937d10819bff59.vehicle',
      'namespace' => 'easycomm',
    ),
    38 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => 'd1853400ba6588ffc580e8e1daf34aff',
      'native_key' => 'OnEcMessageSave',
      'filename' => 'modEvent/35d15e6d8c1f028cee0d1e20eb411253.vehicle',
      'namespace' => 'easycomm',
    ),
    39 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '1be919f3c460447593fe769eb0dbb528',
      'native_key' => 'OnBeforeEcMessagePublish',
      'filename' => 'modEvent/8e91455a1b9b622082791bdda3513536.vehicle',
      'namespace' => 'easycomm',
    ),
    40 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '0f5d69b4c98c337f1bfa169298551bd7',
      'native_key' => 'OnEcMessagePublish',
      'filename' => 'modEvent/852f269f2bfa65bbc99362bfe7496170.vehicle',
      'namespace' => 'easycomm',
    ),
    41 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '0d4374f901b383cb113c22e7bb940826',
      'native_key' => 'OnBeforeEcMessageUnpublish',
      'filename' => 'modEvent/ebd36e37f561f0246e0a7f048f7075cf.vehicle',
      'namespace' => 'easycomm',
    ),
    42 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => 'dae3d4eb45493ee6e3ccc483a8096736',
      'native_key' => 'OnEcMessageUnpublish',
      'filename' => 'modEvent/c8cdb4923c5eb03201d9611a6c690cf0.vehicle',
      'namespace' => 'easycomm',
    ),
    43 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => 'ac8307bb541fe4e1cd27ce9c5aedd802',
      'native_key' => 'OnBeforeEcMessageDelete',
      'filename' => 'modEvent/7ccc26daa0699c3ccb6987f137269c54.vehicle',
      'namespace' => 'easycomm',
    ),
    44 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '2a47ca6097fbda8efb681e9c65c842af',
      'native_key' => 'OnEcMessageDelete',
      'filename' => 'modEvent/4e4851bd3403602e9bd151841e00ee8d.vehicle',
      'namespace' => 'easycomm',
    ),
    45 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '1ef486a480f49e3e021d7f78d47d51d7',
      'native_key' => 'OnBeforeEcMessageUndelete',
      'filename' => 'modEvent/d46155ae5679aa0c65989a4b0b4afdeb.vehicle',
      'namespace' => 'easycomm',
    ),
    46 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '3719847c10baf52eed9797f83e98dfe5',
      'native_key' => 'OnEcMessageUndelete',
      'filename' => 'modEvent/b12f59e3ccc1e5864a1c6e7783ef614f.vehicle',
      'namespace' => 'easycomm',
    ),
    47 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '31f8319a58829d1778163cadf832e02b',
      'native_key' => 'OnBeforeEcMessageRemove',
      'filename' => 'modEvent/f7e5c7dc7b9a03e435096ca5fdc40c88.vehicle',
      'namespace' => 'easycomm',
    ),
    48 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => 'fbe2d85e8cf2989424f8489ba5ce8c18',
      'native_key' => 'OnEcMessageRemove',
      'filename' => 'modEvent/0ac7aa6aa69355ac54a42be4de21b755.vehicle',
      'namespace' => 'easycomm',
    ),
    49 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '84718211632ee3c1bbcf694f630c3716',
      'native_key' => 'OnBeforeEcReplySave',
      'filename' => 'modEvent/95efd687d29ed7f1720de5d37cbed8a2.vehicle',
      'namespace' => 'easycomm',
    ),
    50 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '57c9c6e07594f1598215f95a55dcc4d3',
      'native_key' => 'OnEcReplySave',
      'filename' => 'modEvent/8c7e7baa79cbab7b6ed62c8486dc28d9.vehicle',
      'namespace' => 'easycomm',
    ),
    51 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '80322707c93b77df6b0973195d28d7ea',
      'native_key' => 'OnBeforeEcReplyPublish',
      'filename' => 'modEvent/9a8d99b473f74da701cf21eb8df070de.vehicle',
      'namespace' => 'easycomm',
    ),
    52 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => 'cc2b59f524718b745bfc69b3f1171939',
      'native_key' => 'OnEcReplyPublish',
      'filename' => 'modEvent/8754144aa45d281d8a44d80bb3d61a56.vehicle',
      'namespace' => 'easycomm',
    ),
    53 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => 'f8c4f5eb095a1e6d1546fa216aa4e82f',
      'native_key' => 'OnBeforeEcReplyUnPublish',
      'filename' => 'modEvent/4255b388d7543e0a0ed05774f1138715.vehicle',
      'namespace' => 'easycomm',
    ),
    54 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => 'bc35d777ee8dc6d76b1344d32cf96a4a',
      'native_key' => 'OnEcReplyUnPublish',
      'filename' => 'modEvent/915df58c9495c25c5d05763f431921ba.vehicle',
      'namespace' => 'easycomm',
    ),
    55 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '3ff602424f6eae5601959f345b73b47a',
      'native_key' => 'OnBeforeEcReplyRemove',
      'filename' => 'modEvent/39407976821423eb031b753acb216ef4.vehicle',
      'namespace' => 'easycomm',
    ),
    56 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modEvent',
      'guid' => '5ec92174e153379216f642f65fd4d0a4',
      'native_key' => 'OnEcReplyRemove',
      'filename' => 'modEvent/0e708a93de389604ead9bdbeb72702fe.vehicle',
      'namespace' => 'easycomm',
    ),
    57 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modMenu',
      'guid' => '994012482ab3428f6ff0c17c28408e0a',
      'native_key' => 'easyComm',
      'filename' => 'modMenu/958a19c2d2cc1205c573b850aac08d86.vehicle',
      'namespace' => 'easycomm',
    ),
    58 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOScriptVehicle',
      'class' => 'xPDOScriptVehicle',
      'guid' => 'a25fd4638d91520652d04ceba92ff5f3',
      'native_key' => 'a25fd4638d91520652d04ceba92ff5f3',
      'filename' => 'xPDOScriptVehicle/9e8bbd51155fc3b9d523d252713d401d.vehicle',
      'namespace' => 'easycomm',
    ),
  ),
);