<?php

if (empty($_REQUEST['action'])) {
    die('Access denied');
} else {
    $action = $_REQUEST['action'];
}

define('MODX_API_MODE', true);


// Load MODX
if (strpos('Extras/easyComm', __FILE__) !== false) {
    // dev mode
    require_once dirname(__FILE__, 6) . '/index.php';
} else {
    // release
    require_once dirname(__FILE__, 4) . '/index.php';
}

/** @var modX $modx */
$modx->getService('error', 'error.modError');
$modx->getRequest();
$modx->setLogLevel(modX::LOG_LEVEL_ERROR);
$modx->setLogTarget('FILE');
$modx->error->message = null;


// Get properties
$properties = array();

$modx->addPackage('easycomm', $modx->getOption('ec_core_path', null, $modx->getOption('core_path') . 'components/easycomm/') . 'model/');

/* @var ecThread $thread */
if (!empty($_REQUEST['thread']) && $thread = $modx->getObject('ecThread', array('name' => $_REQUEST['thread']))) {
    $properties = $thread->get('properties');

    /* @var modResource $resource */
    if ($resource = $thread->getOne('Resource')) {
        if ($resource->get('context_key') != 'web') {
            $modx->switchContext($resource->get('context_key'));
        }
        // $modx->resource = $resource;
    }
}

define('MODX_ACTION_MODE', true);
/* @var easyComm $easyComm */
$easyComm = $modx->getService('easyComm', 'easyComm', $modx->getOption('ec_core_path', null, $modx->getOption('core_path') . 'components/easycomm/') . 'model/easycomm/');
if ($modx->error->hasError() || !($easyComm instanceof easyComm)) {
    die('Error');
}

switch ($action) {
    case 'message/create':
        $easyComm->setConfig($properties['ecForm']);
        $response = $easyComm->createMessage($_POST);
        break;
    case 'message/check-files':
        $easyComm->setConfig($properties['ecForm']);
        $response = $easyComm->checkFiles($_POST);
        break;
    case 'message/vote':
        $response = $easyComm->voteMessage($_POST);
        break;
    case 'reply/create':
        $easyComm->setConfig($properties['ecReplyForm']);
        $response = $easyComm->createReply($_POST);
        break;
    default:
        $response = $modx->toJSON(array('success' => false, 'message' => $modx->lexicon('ec_unknown_action')));
}

if (is_array($response)) {
    $response = $modx->toJSON($response);
}
@session_write_close();
exit($response);