easyComm.panel.Settings = function (config) {
    config = config || {};
    Ext.apply(config, {
        cls: 'container',
        items: [{
            html: '<h2>' + _('easycomm') + ' :: ' + _('ec_settings') + '</h2>',
            cls: 'modx-page-header',
            style: {margin: '15px 0'}
        }, {
            xtype: 'modx-tabs',
            id: 'ec-settings-tabs',
            stateful: true,
            stateId: 'ec-settings-tabs',
            stateEvents: ['tabchange'],
            defaults: {border: false, autoHeight: true},
            border: true,
            hideMode: 'offsets',
            getState: function () {
                return {
                    activeTab: this.items.indexOf(this.getActiveTab())
                };
            },
            listeners: {
                tabchange: function (tabPanel, tab) {
                    window.location.hash = '#' + tab.id;
                },
                render: function (tabPanel) {
                    let tabHash = window.location.hash.substring(1);
                    if (tabHash) {
                        let tab = tabPanel.get(tabHash);
                        if (tab) {
                            tabPanel.setActiveTab(tab);
                        }
                    }
                }
            },
            items: [{
                title: _('ec_reply_templates'),
                layout: 'anchor',
                id: 'tab-reply-templates',
                items: [{
                    html: _('ec_reply_templates_intro_msg'),
                    cls: 'panel-desc'
                }, {
                    xtype: 'ec-grid-reply-templates',
                    cls: 'main-wrapper',
                }]
            }]
        }]
    });
    easyComm.panel.Settings.superclass.constructor.call(this, config);
};
Ext.extend(easyComm.panel.Settings, MODx.Panel);
Ext.reg('ec-panel-settings', easyComm.panel.Settings);