easyComm.grid.Replies = function (config) {
    config = config || {};
    if (!config.id) {
        config.id = 'ec-grid-replies';
    }
    config.resource_id = config.resource_id || 0;
    config.thread_id = config.thread_id || 0;
    config.message_id = config.message_id || 0;
    //config.record.id = config.record.id || 0;
    this.sm = new Ext.grid.CheckboxSelectionModel();
    Ext.applyIf(config, {
        url: easyComm.config.connector_url,
        fields: 'id,created_on,user_name,user_email,text,ip,published,thread_name,preview_url' . split(','),
        columns: this.getColumns(config),
        tbar: this.getTopBar(config),
        sm: this.sm,
        baseParams: {
            action: 'mgr/reply/getlist',
            resource_id: config.resource_id,
            thread_id: config.thread_id,
            message_id: config.message_id
        },
        listeners: {
            rowDblClick: function (grid, rowIndex, e) {
                var row = grid.store.getAt(rowIndex);
                this.updateReply(grid, e, row);
            },
            afterrender: function (grid) {
                var params = easyComm.utils.Hash.get();
                var reply = params['ecreply'] || false;
                if (reply) {
                    var resourceTabs = Ext.getCmp("modx-resource-tabs");
                    if (resourceTabs) {
                        resourceTabs.setActiveTab(resourceTabs.findById("ec-panel-page"));
                    }
                    this.updateReply(grid, Ext.EventObject, { data: { id: reply } });
                }
            }
        },
        viewConfig: {
            forceFit: true,
            enableRowBody: true,
            autoFill: true,
            showPreview: true,
            scrollOffset: 0,
            getRowClass: function (rec, ri, p) {
                if (rec.data.deleted) {
                    return 'ec-grid-row-deleted';
                }
                return !rec.data.published ? 'ec-grid-row-disabled' : '';
            }
        },
        paging: true,
        remoteSort: true,
        autoHeight: true
    });
    easyComm.grid.Replies.superclass.constructor.call(this, config);

    // Clear selection on grid refresh
    this.store.on('load', function (store, records) {
        if (this._getSelectedIds().length) {
            this.getSelectionModel().clearSelections();
        }
        // Update tab header
        if(this.id === 'ec-grid-replies') {
            let tab = Ext.getCmp('ec-replies-tab');
            if(tab) {
                let newCount = store.reader.jsonData.new
                    ? ' <i class="ec-tab-badge ec-badge ec-badge--default">+' + store.reader.jsonData.new + '</i>'
                    : '';
                tab.setTitle(_('ec_replies') + newCount);
            }
        } else {
            const tab_id = this.id.replace('-message-replies', '-message-tab-replies')
            const tab = Ext.getCmp(tab_id);
            if(tab) {
                if(records && records.length > 0){
                    tab.setTitle(_('ec_message_tab_replies') + '<i class="ec-tab-indicator"></i>');
                } else {
                    tab.setTitle(_('ec_message_tab_replies'));
                }
            }
        }
    }, this);
};
Ext.extend(easyComm.grid.Replies, MODx.grid.Grid, {
    windows: {},

    getMenu: function (grid, rowIndex) {
        var ids = this._getSelectedIds();

        var row = grid.getStore().getAt(rowIndex);

        var m = [];
        if (ids.length > 1) {
            m.push({ text: '<i class="x-menu-item-icon icon icon-power-off"></i>' + _('ec_action_publish_multiple'), handler: this.publishReply });
            m.push({ text: '<i class="x-menu-item-icon icon icon-power-off"></i>' + _('ec_action_unpublish_multiple'), handler: this.unPublishReply });
            m.push('-');
            m.push({ text: '<i class="x-menu-item-icon icon icon-remove"></i>' + _('ec_action_remove_multiple'), handler: this.removeReply });
        } else {
            m.push({ text: '<i class="x-menu-item-icon icon icon-edit"></i>' + _('ec_action_update'), handler: this.updateReply });
            m.push({
                text: row.data.published ? '<i class="x-menu-item-icon icon icon-power-off"></i>' + _('ec_action_unpublish') : '<i class="x-menu-item-icon icon icon-power-off action-green"></i>' + _('ec_action_publish'),
                handler: row.data.published ? this.unPublishReply : this.publishReply
            });
            if (row.data.published && row.data.preview_url) {
                m.push('-');
                m.push({ text: '<i class="x-menu-item-icon icon icon-eye"></i>' + _('ec_action_view_on_site'), handler: this.viewReply });
            }
            m.push('-');
            m.push({ text: '<i class="x-menu-item-icon icon icon-remove"></i>' + _('ec_action_remove'), handler: this.removeReply });
        }

        this.addContextMenuItem(m);
    },

    createReply: function (btn, e) {
        var w = MODx.load({
            xtype: 'ec-reply-window-create',
            id: Ext.id(),
            listeners: {
                success: {
                    fn: function () {
                        this.refresh();
                    }, scope: this
                }
            }
        });
        w.reset();
        w.setValues({
            published: true
        });
        w.show(e.target);
    },

    updateReply: function (btn, e, row) {
        if (typeof (row) != 'undefined') {
            this.menu.record = row.data;
        }
        else if (!this.menu.record) {
            return false;
        }
        var id = this.menu.record.id;

        MODx.Ajax.request({
            url: this.config.url,
            params: {
                action: 'mgr/reply/get',
                id: id
            },
            listeners: {
                success: {
                    fn: function (r) {
                        var w = MODx.load({
                            xtype: 'ec-reply-window-update',
                            id: Ext.id(),
                            record: r,
                            listeners: {
                                success: {
                                    fn: function () {
                                        this.refresh();
                                    }, scope: this
                                },
                                hide: {
                                    fn: function () {
                                        easyComm.utils.Hash.remove('ecreply');
                                    }
                                },
                                afterrender: function () {
                                    easyComm.utils.Hash.add('ecreply', r.object['id']);
                                }
                            }
                        });
                        w.reset();
                        w.setValues(r.object);
                        w.show(e.target);
                    }, scope: this
                }
            }
        });
    },

    // some action with one or multiple replies
    replyAction: function (actionMethod) {
        var ids = this._getSelectedIds();
        if (!ids.length) {
            return false;
        }

        MODx.Ajax.request({
            url: this.config.url,
            params: {
                action: 'mgr/reply/multiple',
                actionMethod: actionMethod,
                ids: Ext.util.JSON.encode(ids)
            },
            listeners: {
                success: {
                    fn: function () {
                        this.refresh();
                    }, scope: this
                },
                failure: {
                    fn: function (response) {
                        MODx.msg.alert(_('error'), response.reply);
                    }, scope: this
                }
            }
        })
    },

    publishReply: function (act, btn, e) {
        this.replyAction('publish');
    },
    unPublishReply: function (act, btn, e) {
        this.replyAction('unpublish');
    },

    viewReply: function (act, btn, e) {
        window.open(this.menu.record['preview_url'] + '#ec-' + this.menu.record['thread_name'] + '-reply-' + this.menu.record['id']);
        return false;
    },

    removeReply: function (act, btn, e) {
        var ids = this._getSelectedIds();
        Ext.MessageBox.confirm(
            ids.length > 1 ? _('ec_action_remove_multiple') : _('ec_action_remove'),
            ids.length > 1 ? _('ec_action_remove_multiple_confirm') : _('ec_action_remove_confirm'),
            function (val) {
                if (val == 'yes') {
                    this.replyAction('remove');
                }
            },
            this
        );
    },

    getColumns: function (config) {
        let fields = [];
        fields.push(this.sm, {
            header: _('ec_reply_id'),
            dataIndex: 'id',
            sortable: true,
            width: 20
        }, {
            header: _('ec_reply_created_on'),
            dataIndex: 'created_on',
            sortable: true,
            width: 100
        }, {
            header: _('ec_reply_user_name'),
            dataIndex: 'user_name',
            sortable: true,
            width: 100
        }, {
            header: _('ec_reply_user_email'),
            dataIndex: 'user_email',
            sortable: true,
            width: 100
        }, {
            header: _('ec_reply_text'),
            dataIndex: 'text',
            sortable: false,
            width: 200
        }, {
            header: _('ec_reply_ip'),
            dataIndex: 'ip',
            sortable: true,
            width: 100
        }, {
            header: _('ec_reply_published'),
            dataIndex: 'published',
            sortable: true,
            width: 90,
            renderer: easyComm.utils.renderBoolean
        });


        return fields;
    },

    getTopBar: function (config) {
        var result = [];
        result.push('->');

        result.push({
            xtype: 'textfield',
            name: 'query',
            width: 200,
            id: config.id + '-search-field',
            emptyText: _('ec_grid_search'),
            listeners: {
                render: {
                    fn: function (tf) {
                        tf.getEl().addKeyListener(Ext.EventObject.ENTER, function () {
                            this._doSearch(tf);
                        }, this);
                    }, scope: this
                }
            }
        });
        result.push({
            xtype: 'button',
            id: config.id + '-search-clear',
            text: '<i class="icon icon-times"></i>',
            listeners: {
                click: { fn: this._clearSearch, scope: this }
            }
        });
        return result;
    },

    onClick: function (e) {
        var elem = e.getTarget();
        if (elem.nodeName == 'BUTTON') {
            var row = this.getSelectionModel().getSelected();
            if (typeof (row) != 'undefined') {
                var action = elem.getAttribute('action');
                if (action == 'showMenu') {
                    var ri = this.getStore().find('id', row.id);
                    return this._showMenu(this, ri, e);
                }
                else if (typeof this[action] === 'function') {
                    this.menu.record = row.data;
                    return this[action](this, e);
                }
            }
        }
        return this.processEvent('click', e);
    },

    _getSelectedIds: function () {
        var ids = [];
        var selected = this.getSelectionModel().getSelections();

        for (var i in selected) {
            if (!selected.hasOwnProperty(i)) {
                continue;
            }
            ids.push(selected[i]['id']);
        }

        return ids;
    },

    _doFilter: function (tf, nv, ov) {
        this.getStore().baseParams.filter = tf.getValue();
        this.getBottomToolbar().changePage(1);
        this.refresh();
    },
    _doSearch: function (tf, nv, ov) {
        this.getStore().baseParams.query = tf.getValue();
        this.getBottomToolbar().changePage(1);
        this.refresh();
    },

    _clearSearch: function (btn, e) {
        this.getStore().baseParams.query = '';
        Ext.getCmp(this.config.id + '-search-field').setValue('');
        this.getBottomToolbar().changePage(1);
        this.refresh();
    }
});
Ext.reg('ec-grid-replies', easyComm.grid.Replies);