// Base windows
easyComm.window.ReplyWindow = function (config) {
    config = config || {};
    if (!config.id) {
        config.id = 'ec-reply-window';
    }
    easyComm.window.ReplyWindow.superclass.constructor.call(this, config);
}

Ext.extend(easyComm.window.ReplyWindow, MODx.Window, {
    getReplyWindowFields: function (config, record) {
        let result = [];
        if (record) {
            result.push({ xtype: 'hidden', name: 'id', id: config.id + '-id' });
        }

        result.push({
            xtype: 'fieldset',
            title: 'Ответ на:',
            layout: 'column',
            defaults: { msgTarget: 'under', border: false },
            items: [{
                columnWidth: 1,
                layout: 'form',
                items: {
                    layout: 'column',
                    border: false,
                    items: [{
                        columnWidth: .5,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: 'displayfield',
                            fieldLabel: _('ec_message_resource_pagetitle'),
                            name: 'resource_pagetitle',
                            id: config.id + '-resource',
                            anchor: '99%',
                        },{
                            xtype: 'displayfield',
                            fieldLabel: _('ec_message'),
                            name: 'message_id',
                            id: config.id + '-message_id',
                            anchor: '99%',
                        }]
                    }, {
                        columnWidth: .5,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: 'displayfield',
                            fieldLabel: _('ec_message_thread_name'),
                            name: 'thread_name',
                            id: config.id + '-thread_name',
                            anchor: '99%',
                        },{
                            xtype: 'displayfield',
                            fieldLabel: _('ec_reply'),
                            name: 'parent_id',
                            id: config.id + '-parent_id',
                            anchor: '99%',
                        }]
                    }]
                },
            }]
        });
        result.push({
            layout: 'column',
            border: false,
            items: [{
                columnWidth: .5,
                border: false,
                layout: 'form',
                items: [{
                    xtype: 'textfield',
                    fieldLabel: _('ec_reply_user_name'),
                    name: 'user_name',
                    id: config.id + '-user_name',
                    anchor: '99%',
                    allowBlank: true,
                }]
            }, {
                columnWidth: .5,
                border: false,
                layout: 'form',
                items: [{
                    xtype: 'textfield',
                    fieldLabel: _('ec_reply_user_email'),
                    name: 'user_email',
                    id: config.id + '-user_email',
                    anchor: '99%',
                    allowBlank: true,
                }]
            }]
        }, {
            xtype: 'textarea',
            fieldLabel: _('ec_reply_text'),
            name: 'text',
            id: config.id + '-text',
            anchor: '99%',
            allowBlank: true,
        }, {
            xtype: 'xcheckbox',
            boxLabel: _('ec_reply_published'),
            name: 'published',
            id: config.id + '-published'
        });

        return result;
    }
});

easyComm.window.ReplyWindowCreate = function (config) {
    config = config || {};
    if (!config.id) {
        config.id = 'ec-reply-window-create';
    }
    Ext.applyIf(config, {
        title: _('ec_action_create'),
        width: 650,
        autoHeight: true,
        //bwrapCssClass: 'x-window-with-tabs',
        url: easyComm.config.connector_url,
        action: 'mgr/reply/create',
        fields: this.getReplyWindowFields(config, null),
        keys: [{
            key: Ext.EventObject.ENTER, shift: true, fn: function () {
                this.submit()
            }, scope: this
        }]
    });
    easyComm.window.ReplyWindowCreate.superclass.constructor.call(this, config);
};
Ext.extend(easyComm.window.ReplyWindowCreate, easyComm.window.ReplyWindow, {});
Ext.reg('ec-reply-window-create', easyComm.window.ReplyWindowCreate);


easyComm.window.ReplyWindowUpdate = function (config) {
    config = config || {};
    if (!config.id) {
        config.id = 'ec-reply-window-update';
    }
    Ext.applyIf(config, {
        title: _('ec_action_update'),
        width: 650,
        autoHeight: true,
        //bwrapCssClass: 'x-window-with-tabs',
        url: easyComm.config.connector_url,
        action: 'mgr/reply/update',
        fields: this.getReplyWindowFields(config, config.record),
        keys: [{
            key: Ext.EventObject.ENTER, shift: true, fn: function () {
                this.submit()
            }, scope: this
        }]
    });
    easyComm.window.ReplyWindowUpdate.superclass.constructor.call(this, config);
};
Ext.extend(easyComm.window.ReplyWindowUpdate, easyComm.window.ReplyWindow, {});
Ext.reg('ec-reply-window-update', easyComm.window.ReplyWindowUpdate);