<?php

/**
 * Remove a File
 */
class easyCommFileRemoveProcessor extends modProcessor {
    public $languageTopics = array('easycomm');
    public $permission = 'ec_message_save';

    /** @var easyComm $easyComm */
    protected $easyComm;

    /** @var  ecMessage  */
    private $message;

    /**
     * Can be used to provide custom methods prior to processing. Return true to tell MODX that the Processor
     * initialized successfully. If you return anything else, MODX will output that return value as an error message.
     *
     * @return boolean
     */
    public function initialize() {
        $this->message = $this->modx->getObject('ecMessage', intval($this->getProperty('message', 0)));
        if (!($this->message instanceof ecMessage)) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Failed to get message object while deleting files');
            return false;
        }

        if (!$this->easyComm = $this->modx->getService('easyComm')) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Failed to get easyComm service while deleting files');
            return false;
        }
        return parent::initialize();
    }

    /**
     * Log the removal manager action
     * @return void
     */
    public function logManagerAction() {
        $this->modx->logManagerAction('ecMessage_file_remove', 'ecMessage', $this->message->get('id'));
    }

    /**
     * Run the processor and return the result. Override this in your derivative class to provide custom functionality.
     * Used here for pre-2.2-style processors.
     *
     * @return array|string
     */
    public function process() {
        $toRemove = json_decode($this->getProperty('files'), true);
        if (empty($toRemove)) {
            return $this->success();
        }

        try {
            $context = $this->message->getOne('Thread')->getOne('Resource')->get('context_key');
            $mediaManager = $this->easyComm->getMediaManager($context);
        } catch (Exception $e) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Failed to get media manager object while deleting files');
            return $this->failure($this->modx->lexicon('ec_message_file_err_remove'));
        }

        $count = 0;
        $size = 0;
        $files = array();
        $currentFiles = $this->message->get('files');
        foreach($currentFiles as $file) {
            if (in_array($file['path'], $toRemove)) {
                $mediaManager->removeObject($file['path']);
                if(!empty($file['thumb_path'])) {
                    $mediaManager->removeObject($file['thumb_path']);
                }
            }
            else {
                $files[] = $file;
                $count++;
                $size = $size + $file['size'];
            }
        }

        $this->message->set('files', $files);
        $this->message->set('files_count', $count);
        $this->message->set('files_size', $size);
        $this->message->save();


        return $this->success($count);
    }
}

return 'easyCommFileRemoveProcessor';