<?php

/**
 * Get a list of ecMessage
 */
class easyCommMessageGetListProcessor extends modObjectGetListProcessor
{
    public $objectType = 'ecMessage';
    public $classKey = 'ecMessage';
    public $defaultSortField = 'id';
    public $defaultSortDirection = 'DESC';
    //public $permission = 'list';

    /**
     * @param xPDOQuery $c
     *
     * @return xPDOQuery
     */
    public function prepareQueryBeforeCount(xPDOQuery $c)
    {
        $c->leftJoin('ecThread', 'Thread', '`ecMessage`.`thread_id` = `Thread`.`id`');
        $c->leftJoin('modResource', 'Resource', '`Thread`.`resource_id` = `Resource`.`id`');
        $c->leftJoin('ecReply', 'Reply', '`ecMessage`.`id` = `Reply`.`message_id`');

        $c->select($this->modx->getSelectColumns($this->classKey, $this->classKey, ''));
        $c->select($this->modx->getSelectColumns('ecThread', 'Thread', 'thread_', ['resource_id', 'name', 'title']));
        $c->select($this->modx->getSelectColumns('modResource', 'Resource', 'resource_', ['id', 'pagetitle', 'context_key']));

        // Выбираем общее количество ответов и количество опубликованных
        $c->select('COUNT(`Reply`.`id`) as `replies_count`');
        $c->select('SUM(CASE WHEN `Reply`.`published` = 0 THEN 1 ELSE 0 END) as `new_replies_count`');

        $c->groupby('`ecMessage`.`id`');

        $c = $this->addCommonCriteria($c);

        return $this->addSearchCriteria($c);
    }

    private function addCommonCriteria(xPDOQuery $c)
    {
        $resource_id = intval($this->getProperty('resource_id'));
        if (!empty($resource_id)) {
            $c->where(array('`Thread`.`resource_id`' => $resource_id));
        }

        if ($thread_id = $this->getProperty('thread_id')) {
            if (!empty($thread_id)) {
                $c->where(array('`Thread`.`id`' => $thread_id));
            }
        }

        $filter = trim($this->getProperty('filter'));
        if ($filter) {
            if (strpos($filter, "%") === false) {
                $c->where(array(
                    '`Thread`.`name`' => $filter
                ));
            } else {
                $c->where(array(
                    '`Thread`.`name`:LIKE' => $filter
                ));
            }
        }

        return $c;
    }

    private function addSearchCriteria(xPDOQuery $c)
    {
        $query = trim($this->getProperty('query'));
        if ($query) {
            $c->where(array(
                'user_name:LIKE' => "%{$query}%",
                'OR:user_email:LIKE' => "%{$query}%",
                'OR:user_contacts:LIKE' => "%{$query}%",
                'OR:text:LIKE' => "%{$query}%",
                'OR:reply_author:LIKE' => "%{$query}%",
                'OR:reply_text:LIKE' => "%{$query}%",
            ));
        }
        return $c;
    }

    /**
     * @param xPDOObject $object
     *
     * @return array
     */
    public function prepareRow(xPDOObject $object)
    {
        $array = $object->toArray();

        if (!empty($array['resource_id'])) {
            $array['preview_url'] = $this->modx->makeUrl($array['resource_id'], $array['resource_context_key']);
            $array['resource_pagetitle'] = '<a href="?a=resource/update&id=' . $array['resource_id'] . '" target="_blank">' . $array['resource_pagetitle'] . '</a>';
        }
        $array['reply_text'] = strip_tags($array['reply_text']);

        // Replies summary
        $repliesCount = $object->get('replies_count');
        if (!empty($array['reply_text'])) {
            $repliesCount++;
        }
        $array['replies'] = $repliesCount;
        $array['replies_new'] = $object->get('new_replies_count');

        return $array;
    }

    /** {@inheritDoc} */
    public function outputArray(array $array, $count = false)
    {
        if ($count === false) {
            $count = count($array);
        }
        $output = json_encode(array(
            'success' => true,
            'total' => $count,
            'results' => $array,
            'new' => $this->getCountOfNewMessages()
        ));
        if ($output === false) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Processor failed creating output array due to JSON error ' . json_last_error());
            return json_encode(array('success' => false));
        }
        return $output;
    }

    private function getCountOfNewMessages()
    {
        $c = $this->modx->newQuery($this->classKey);
        $c->leftJoin('ecThread', 'Thread', '`ecMessage`.`thread_id` = `Thread`.`id`');
        $c->select($this->modx->getSelectColumns($this->classKey, $this->objectType, ''));
        $c->where([
            'ecMessage.published' => false,
            'ecMessage.deleted' => false,
        ]);

        $c = $this->addCommonCriteria($c);
        return $this->modx->getCount($this->classKey, $c);
    }

}

return 'easyCommMessageGetListProcessor';