<?php

/**
 * Update an ecMessage
 */
class easyCommMessageUpdateProcessor extends modObjectUpdateProcessor
{
    public $objectType = 'ecMessage';
    public $classKey = 'ecMessage';
    public $languageTopics = array('easycomm');
    public $permission = 'ec_message_save';

    public $beforeSaveEvent = 'OnBeforeEcMessageSave';
    public $afterSaveEvent = 'OnEcMessageSave';

    /** @var ecMessage $object */
    public $object;

    /** @var ecThread $thread */
    private $thread;

    /**
     * @return bool
     */
    public function beforeSet()
    {
        $id = (int)$this->getProperty('id');
        /** @var easyComm $easyComm */
        $easyComm = $this->modx->getService('easyComm');

        if (empty($id)) {
            return $this->modx->lexicon('ec_message_err_ns');
        }

        $threadId = $this->getProperty('thread_id');
        if (!$this->thread = $this->modx->getObject('ecThread', $threadId)) {
            $this->modx->error->addField('thread_id', $this->modx->lexicon('ec_message_err_thread'));
        }

        $ratingMax = intval($this->modx->getOption('ec_rating_max'));
        $ratingFields = $easyComm->getEcMessageRatingFields();
        foreach ($ratingFields as $field) {
            $value = intval($this->getProperty($field));
            if ($value < 0) {
                $value = 0;
            }
            if ($value > $ratingMax) {
                $value = $ratingMax;
            }
            $this->setProperty($field, $value);
        }

        $now = date('Y-m-d H:i:s');
        $this->setProperties(array(
            'edited_on' => $now,
            'edited_by' => $this->modx->user->isAuthenticated($this->modx->context->key) ? $this->modx->user->id : 0,
        ));
        if ($this->getProperty('published')) {
            $this->setProperties(array(
                'published_on' => $now,
                'published_by' => $this->modx->user->isAuthenticated($this->modx->context->key) ? $this->modx->user->id : 0,
            ));
        } else {
            $this->setProperties(array(
                'published_on' => null,
                'published_by' => 0,
            ));
        }
        return parent::beforeSet();
    }

    /** {@inheritDoc} */
    public function afterSave()
    {
        $this->thread->updateMessagesInfo();

        if ($this->object->get('notify')
            || (!$this->object->get('notify_date') && $this->object->get('published'))) {
            $notifier = new easyCommNotifier($this->modx);
            $notifier->notify($this->object, false, true);

            $this->object->set('notify', 0);
            $this->object->set('notify_date', date('Y-m-d H:i:s'));
            $this->object->save();
        }

        // Обновим thread_id у ответов, т.к. сообщение могло сменить цепочку
        $set = [
            'thread_id' => $this->object->get('thread_id')
        ];
        $criteria = [
            'message_id' => $this->object->get('id'),
        ];
        $this->modx->updateCollection('ecReply', $set, $criteria);

        return parent::afterSave();
    }
}

return 'easyCommMessageUpdateProcessor';