<?php

/**
 * Get an ecReply
 */
class easyCommReplyGetProcessor extends modObjectGetProcessor
{
    public $objectType = 'ecReply';
    public $classKey = 'ecReply';
    public $languageTopics = array('easycomm:default');

    //public $permission = 'view';

    public function cleanup()
    {
        $data = $this->object->toArray();
        /** @var ecMessage $message */
        $message = $this->object->getOne('Message');
        if ($message) {
            /** @var ecThread $thread */
            $thread = $message->getOne('Thread');
            if ($thread) {
                $data['thread_name'] = $thread->get('name');
                /** @var modResource $resource */
                $resource = $thread->getOne('Resource');
                if ($resource) {
                    $resourceLink = $this->modx->makeUrl($resource->get('id'), $resource->get('context_key'));
                    $data['resource_pagetitle'] = sprintf('<a href="%s" target="_blank">%s</a> (%s)', $resourceLink, $resource->get('pagetitle'), $resource->get('id'));
                }
            }
        }

        return $this->success('', $data);
    }
}

return 'easyCommReplyGetProcessor';