<?php

/**
 * Update an ecReply
 */
class easyCommReplyUpdateProcessor extends modObjectUpdateProcessor
{
    public $objectType = 'ecReply';
    public $classKey = 'ecReply';
    public $languageTopics = array('easycomm');
    public $permission = 'ec_message_save';

    public $beforeSaveEvent = 'OnBeforeEcReplySave';
    public $afterSaveEvent = 'OnEcReplySave';

    /** @var ecReply $object */
    public $object;

    /**
     * @return bool
     */
    public function beforeSet()
    {
        $now = date('Y-m-d H:i:s');
        $user = $this->modx->user->isAuthenticated($this->modx->context->key) ? $this->modx->user->id : 0;
        $this->setProperties(array(
            'edited_on' => $now,
            'edited_by' => $user,
        ));
        if ($this->getProperty('published')) {
            $this->setProperties(array(
                'published_on' => $now,
                'published_by' => $user,
            ));
        } else {
            $this->setProperties(array(
                'published_on' => null,
                'published_by' => 0,
            ));
        }

        return parent::beforeSet();
    }

    /**
     * @return bool
     */
    public function afterSave()
    {
        if($this->object->get('published') && !$this->object->get('notify_date')) {
            $notifier = new easyCommNotifier($this->modx);
            $notifier->notify($this->object, false, true, true);

            $this->object->set('notify_date', date('Y-m-d H:i:s'));
            $this->object->save();
        }
        return parent::afterSave();
    }
}

return 'easyCommReplyUpdateProcessor';