<?php

/**
 * Get a list of ecVotes
 */
class easyCommVoteGetListProcessor extends modObjectGetListProcessor {
	public $objectType = 'ecVote';
	public $classKey = 'ecVote';
	public $defaultSortField = 'created_on';
	public $defaultSortDirection = 'DESC';
	//public $permission = 'list';

	/**
	 * @param xPDOQuery $c
	 *
	 * @return xPDOQuery
	 */
	public function prepareQueryBeforeCount(xPDOQuery $c) {

        $message_id = intval($this->getProperty('message_id', 0));
        if($message_id > 0) {
            $c->where(array(
                'message_id' => $message_id
            ));
        }

		$query = trim($this->getProperty('query'));
		if ($query) {
            // TODO: поиск по IP, id (?), Пользователю (?)
			/*$c->where(array(
				'text:LIKE' => "%{$query}%"
			));*/
		}

		return $c;
	}


	/**
	 * @param xPDOObject $object
	 *
	 * @return array
	 */
	public function prepareRow(xPDOObject $object) {
		$array = $object->toArray();
		return $array;
	}

}

return 'easyCommVoteGetListProcessor';