<?php

class easyCommMessageVoteProcessor extends modProcessor
{

    /** @var easyComm $easyComm */
    protected $easyComm;

    /**
     * @return bool
     */
    public function initialize()
    {
        if (!$this->easyComm = $this->modx->getService('easyComm')) {
            return false;
        }
        return parent::initialize();
    }

    /**
     * @return string
     */
    public function process()
    {
        if (!$messageId = $this->getProperty('messageId')) {
            return $this->failure($this->modx->lexicon('ec_fe_vote_error_ns'));
        }
        if (!$value = (int)$this->getProperty('value')) {
            return $this->failure($this->modx->lexicon('ec_fe_vote_error_ns'));
        }
        $value = ($value == 1) ? 1 : -1;

        $ip = $this->easyComm->getClientIp();
        $session = session_id();
        // Собираем массив для выборки
        $where = array(
            'message_id' => $messageId
        );

        if ($this->modx->user->get('id')) {
            $where['created_by'] = $this->modx->user->get('id');
        } else {
            $where['created_by'] = 0;
            if ($this->getProperty('votingConsiderIP', false)) {
                $where[] = array('ip:=' => $ip, 'OR:session:=' => $session);
            } else {
                $where['session'] = $session;
            }
        }

        // Проверим, есть ли уже голос от этого пользователя
        if ($vote = $this->modx->getObject('ecVote', $where)) {
            if ($vote->get('value') == $value) {
                $action = 'remove';
                $params = array(
                    'id' => $vote->get('id'),
                );
            } else {
                $action = 'update';
                $params = array_merge($vote->toArray(), array(
                    'id' => $vote->get('id'),
                    'value' => $value,
                ));
            }
        } else {
            $action = 'create';
            $params = array(
                'message_id' => $messageId,
                'value' => $value,
            );
        }
        // Запускаем другой процессор, который выполнит необходимое действие (создание, удаление, обновление)
        $this->modx->error->reset();
        $response = $this->easyComm->runProcessor(('mgr/vote/' . $action), $params);

        if ($response->isError()) {
            return $response->getResponse();
        }

        return $this->success('', $response->getObject());
    }

    /**
     * @return array
     */
    public function getLanguageTopics()
    {
        return array('easycomm:default');
    }
}

return 'easyCommMessageVoteProcessor';