{if $messages?}
    {foreach $messages as $message}
        <div id="ec-{$message['thread_name']}-message-{$message['id']}" class="ec-message">
            <div class="ec-message__header">
                <div class="ec-message__meta">
                    <span class="ec-message__author">{$message['user_name']}</span>
                    <span class="ec-message__date">{$message['date'] | dateAgo}</span>
                </div>
                {if $message['voting_enable']?}
                    {set $voting_button_classes = $message['voting_can_vote'] ? 'js-ec-vote-button enabled' : ''}
                    <div class="ec-message__votes" data-message-id="{$message['id']}" data-properties-key="{$message['properties_key']}">
                        <div class="ec-message__votes-item">
                            <a href="javascript:void(0)" class="{$voting_button_classes} ec-message__votes-button ec-message__votes-button-like {if $message['vote']==1}active{/if}" data-value="1">
                                {$message['likes']}
                            </a>
                        </div>
                        <div class="ec-message__votes-item">
                            <a href="javascript:void(0)" class="{$voting_button_classes} ec-message__votes-button ec-message__votes-button-dislike {if $message['vote']==-1}active{/if}" data-value="-1">
                                {$message['dislikes']}
                            </a>
                        </div>
                        <div class="ec-message__votes-bar"><span class="js-ec-vote-bar" style="width: {$message['votes_rating_percent']}%"></span></div>
                    </div>
                {/if}
            </div>
            <div class="ec-stars ec-stars--{$message['stars_theme']}">
                <span class="rating-{$message['rating']}"></span>
            </div>
            <p>{$message['text']}</p>
            {if $message['reply_text']?}
                <div class="ec-message__reply">
                    <p>
                        {if $message['reply_author']}
                            <strong>{$message['reply_author']}:</strong>
                        {/if}
                        {$message['reply_text']}
                    </p>
                </div>
            {/if}
            {if $message['files']?}
                <div class="ec-message__files">
                    {foreach $message['files'] as $file}
                        {if $file['thumb_url']?}
                        <a href="{$file['url']}" target="_blank" class="ec-message__files-item ec-file ec-file--thumb">
                            <img src="{$file['thumb_url']}" alt="{$file['title']}" title="{$file['title']}">
                        </a>
                        {else}
                        <a href="{$file['url']}" target="_blank" class="ec-message__files-item ec-file">
                            <div class="ec-file__name">{$file['title']}</div>
                            <div class="ec-file__meta">{$file['extension'] | upper} - {$file['size_str']}</div>
                        </a>
                        {/if}
                    {/foreach}
                </div>
            {/if}
            {if $message['replies_enable']?}
                <div class="ec-message__footer">
                    <a class="ec-message__footer-link js-ec-reply" href="javascript:void(0)"
                       data-ec-thread="{$message['thread_name']}"
                       data-ec-message="{$message['id']}">{'ec_fe_reply' | lexicon}</a>
                </div>
            {/if}
        </div>
        {if $message['replies']?}
            {foreach $message['replies'] as $reply}
                <div id="ec-{$message['thread_name']}-reply-{$reply['id']}" class="ec-reply">
                    <div class="ec-reply__header">
                        <div class="ec-reply__meta">
                            <span class="ec-reply__author">{$reply['user_name']}</span>
                            <span class="ec-reply__date">{$reply['created_on'] | dateAgo}</span>
                        </div>
                    </div>
                    <p>
                        {$reply['text']}
                    </p>
                    {if $message['replies_enable']?}
                        <div class="ec-reply__footer">
                            <a class="ec-reply__footer-link js-ec-reply" href="javascript:void(0)"
                               data-ec-thread="{$message['thread_name']}"
                               data-ec-message="{$message['id']}"
                               data-ec-parent="{$reply['id']}">{'ec_fe_reply' | lexicon}</a>
                        </div>
                    {/if}
                </div>
            {/foreach}
        {/if}
    {/foreach}
{/if}