<?php

/** @var modX $modx */
/** @var array $scriptProperties */
/** @var easyComm $easyComm */
if (!$easyComm = $modx->getService('easyComm', 'easyComm', $modx->getOption('ec_core_path', null, $modx->getOption('core_path') . 'components/easycomm/') . 'model/easycomm/', $scriptProperties)) {
    return 'Could not load easyComm class!';
}
$easyComm->initialize($modx->context->key, $scriptProperties);

/* @var pdoFetch $pdoFetch */
$fqn = $modx->getOption('pdoFetch.class', null, 'pdotools.pdofetch', true);
if ($pdoClass = $modx->loadClass($fqn, '', false, true)) {
    $pdoFetch = new $pdoClass($modx, $scriptProperties);
} elseif ($pdoClass = $modx->loadClass($fqn, MODX_CORE_PATH . 'components/pdotools/model/', false, true)) {
    $pdoFetch = new $pdoClass($modx, $scriptProperties);
} else {
    $modx->log(modX::LOG_LEVEL_ERROR, 'Could not load pdoFetch from "MODX_CORE_PATH/components/pdotools/model/".');
    return false;
}
$pdoFetch->addTime('pdoTools loaded');
$fastMode = !empty($fastMode);

$tpl = $modx->getOption('tpl', $scriptProperties, 'tpl.ecMessages');
$starsTheme = $modx->getOption('starsTheme', $scriptProperties, 'default');

$votingEnable = (bool)$modx->getOption('votingEnable', $scriptProperties, false);
if ($votingEnable) {
    $votingAllowGuest = (bool)$modx->getOption('votingAllowGuest', $scriptProperties, false);
    $votingConsiderIP = (bool)$modx->getOption('votingConsiderIP', $scriptProperties, false);
    // Сохраняем в сессию необходимые параметры для работы голосования
    $propertiesKey = md5(serialize($scriptProperties));
    $_SESSION['easyComm']['ecMessages'][$propertiesKey] = array('votingEnable' => $votingEnable, 'votingAllowGuest' => $votingAllowGuest, 'votingConsiderIP' => $votingConsiderIP);
}

/** @var bool $votingEnable Голосование включено */
$repliesEnable = (bool)$modx->getOption('repliesEnable', $scriptProperties, false);

/* @var string $threads */
$threads = $modx->getOption('threads', $scriptProperties, '');
if ($threads === '*') {
    $threads = array();
} else {
    if (empty($threads)) {
        $threads = $modx->getOption('thread', $scriptProperties, '');
        if (empty($threads)) {
            $threads = 'resource-' . $modx->resource->get('id');
        }
    }
    $threads = explode(",", $threads);
    $threads = array_map('trim', $threads);
}

$class = 'ecMessage';
$threadClass = 'ecThread';
$resourceClass = 'modResource';
// Query conditions
$select = array(
    $class => $modx->getSelectColumns($class, $class),
    $threadClass => $modx->getSelectColumns($threadClass, 'Thread', 'thread_'),
);
$innerJoin = array($threadClass => array('alias' => 'Thread', 'on' => "`$class`.`thread_id` = `Thread`.`id`"));
$leftJoin = array();

if (!empty($resourceFields)) {
    $resourceFields = array_merge(array('id', 'pagetitle'), explode(",", $resourceFields));
    $resourceFields = array_map("trim", $resourceFields);

    $select[$resourceClass] = $modx->getSelectColumns($resourceClass, 'Resource', 'resource_', $resourceFields);
    $leftJoin[$resourceClass] = array('alias' => 'Resource', 'on' => "`Thread`.`resource_id` = `Resource`.`id`");
}

// Получаем информацию о "своем" голосе для вывода
if ($votingEnable) {
    $ip = $easyComm->getClientIp();
    $session = session_id();
    $userId = $modx->user->get('id');
    if (!empty($userId)) {
        $select['ecVote'] = "`Vote`.`value` as `vote`";
        $leftJoin['ecVote'] = array('alias' => 'Vote', 'on' => "`ecMessage`.`id` = `Vote`.`message_id` AND `Vote`.`created_by` = $userId");
    } elseif ($votingAllowGuest) {
        $select['ecVote'] = "`Vote`.`value` as `vote`";
        if ($votingConsiderIP) {
            $leftJoin['ecVote'] = array('alias' => 'Vote', 'on' => "`ecMessage`.`id` = `Vote`.`message_id` AND `Vote`.`created_by` = 0 AND (`Vote`.`session` = '$session' OR `Vote`.`ip` = '$ip')");
        } else {
            $leftJoin['ecVote'] = array('alias' => 'Vote', 'on' => "`ecMessage`.`id` = `Vote`.`message_id` AND `Vote`.`created_by` = 0 AND `Vote`.`session` = '$session'");
        }

    }
}

$where = array();
if (count($threads) == 1) {
    $where['`Thread`.`name`'] = $threads[0];
}
if (count($threads) > 1) {
    $where['`Thread`.`name`:IN'] = $threads;
}

// Filter by message ids
$messages = $modx->getOption('messages', $scriptProperties, '');
if (!empty($messages)) {
    $messages = explode(",", $messages);
    $messages = array_map("trim", $messages);
    $messages = array_map("intval", $messages);
    if (!empty($messages)) {
        $where[$class . '.`id`:IN'] = $messages;
    }
}

if (empty($showUnpublished)) {
    $where[$class . '.published'] = 1;
}

if (empty($showDeleted)) {
    $where[$class . '.deleted'] = 0;
}

if (!empty($subject)) {
    $where[$class . '.subject'] = $subject;
}

$user = intval($modx->getOption('user', $scriptProperties, 0));
if (!empty($user)) {
    $where[$class . '.created_by'] = $user;
}

// Add custom parameters
foreach (array('where', 'leftJoin', 'innerJoin', 'select', 'groupby') as $v) {
    if (!empty($scriptProperties[$v])) {
        $tmp = $scriptProperties[$v];
        if (!is_array($tmp)) {
            $tmp = json_decode($tmp, true);
        }
        if (is_array($tmp)) {
            $$v = array_merge($$v, $tmp);
        }
    }
    unset($scriptProperties[$v]);
}
$pdoFetch->addTime('Conditions prepared');

// Default parameters
$default = array(
    'class' => $class,
    //'loadModels' => 'easyComm',
    'disableConditions' => true,
    'where' => $modx->toJSON($where),
    'select' => $modx->toJSON($select),
    'innerJoin' => $modx->toJSON($innerJoin),
    'leftJoin' => $modx->toJSON($leftJoin),
    'groupby' => $class . '.id',
    'return' => 'data',
    'nestedChunkPrefix' => 'ec_'
);


// Merge all properties and run!
$pdoFetch->addTime('Query parameters ready');
$pdoFetch->setConfig(array_merge($default, $scriptProperties), false);


$rows = $pdoFetch->run();

$threadReplies = null;
if ($repliesEnable && count($rows) > 0) {
    $messageIds = [];
    foreach ($rows as $row) {
        $messageIds[] = $row['id'];
    }

    $repliesCriteria = $modx->newQuery('ecReply');

    $repliesCriteria->where([
        'published' => 1,
        'message_id:IN' => $messageIds
    ]);
    $repliesCriteria->sortby("FIELD(ecReply.message_id, " . implode(',', $messageIds) . ")", 'ASC');
    $repliesCriteria->sortby('created_on', 'ASC');

    $threadReplies = $modx->getIterator('ecReply', $repliesCriteria);
    $threadReplies->rewind();
}

/* @var $tmpChunk modChunk */
$tmpChunk = $modx->newObject('modChunk', array('name' => "tmp-" . uniqid()));
$tmpChunk->setCacheable(false);
$gravatarDefault = $tmpChunk->process(null, $modx->getOption('ec_gravatar_default'));

$gravatarSize = $modx->getOption('ec_gravatar_size', null, 50);

$data = [
    'messages' => []
];
$idx = $pdoFetch->idx;
foreach ($rows as $row) {
    $row['idx'] = $idx++;
    $row['properties_key'] = isset($propertiesKey) ? $propertiesKey : "";
    $row['voting_enable'] = $votingEnable;
    $row['voting_can_vote'] = $votingEnable && (($modx->user->get('id') > 0) || $votingAllowGuest);
    $row['replies_enable'] = $repliesEnable;
    $row['text_raw'] = $row['text'];
    $row['text'] = nl2br($row['text']);
    $row['reply_text_raw'] = $row['reply_text'];
    $row['reply_text'] = nl2br($row['reply_text']);

    $row['gravatar'] = $gravatarDefault;
    if (!empty($row['user_email'])) {
        $row['gravatar'] = 'https://www.gravatar.com/avatar/' . md5(strtolower($row['user_email'])) . '?s=' . $gravatarSize;
        if (!empty($gravatarDefault)) {
            $row['gravatar'] .= '&d=' . urlencode($gravatarDefault);
        }
    }

    $row['votes_rating_percent'] = number_format($row['votes_rating'] * 100, 3, '.', '');

    $row['stars_theme'] = $starsTheme;

    if(is_array($row['files'])) {
        foreach ($row['files'] as &$file) {
            $file['title'] = $easyComm->cyrillicPathinfo($file['name_original'], 'filename');
            $file['size_str'] = $easyComm->humanFileSize($file['size']);
        }
    }

    /** @var Iterator $replies */
    if ($threadReplies instanceof Iterator) {
        $messageReplies = [];
        while ($threadReplies->valid()) {
            $currentReply = $threadReplies->current();
            if ($currentReply->get('message_id') == $row['id']) {
                $currentReplyArray = $currentReply->toArray();
                $currentReplyArray['text_raw'] = $currentReply->get('text');
                $currentReplyArray['text'] = nl2br($currentReplyArray['text_raw']);
                $messageReplies[] = $currentReplyArray;

                $threadReplies->next();
            } else {
                break;
            }
        }
        $row['replies'] = $messageReplies;
    }
    $data['messages'][] = $row;
}

$log = '';
if (!empty($showLog) && $modx->user->hasSessionContext('mgr')) {
    $log .= '<pre class="pdoResourcesLog">' . print_r($pdoFetch->getTime(), 1) . '</pre>';
    $data['log'] = $log;
}

if ((count($threads) == 1) && ($threadObj = $modx->getObject('ecThread', array('name' => $threads[0])))) {
    $threadData = $threadObj->toArray();
    $ratingMax = (float)$modx->getOption('ec_rating_max', $scriptProperties, 5);
    $ratingFields = $easyComm->getEcMessageRatingFields();
    foreach ($ratingFields as $field) {
        $threadData = array_merge($threadData, array(
            $field . '_wilson_percent' => number_format($threadObj->get($field . '_wilson') / $ratingMax * 100, 3, '.', ''),
            $field . '_simple_percent' => number_format($threadObj->get($field . '_simple') / $ratingMax * 100, 3, '.', ''),
        ));
    }

    $data['thread'] = $threadData;
}
$output = $pdoFetch->getChunk($tpl, $data);

if (!empty($toPlaceholder)) {
    $modx->setPlaceholder($toPlaceholder, $output);
} else {
    return $output;
}