<?php

/* @var modX $modx */
/** @var array $scriptProperties */
/** @var easyComm $easyComm */
if (!$easyComm = $modx->getService('easyComm', 'easyComm', $modx->getOption('ec_core_path', null, $modx->getOption('core_path') . 'components/easycomm/') . 'model/easycomm/', $scriptProperties)) {
    return 'Could not load easyComm class!';
}

/* @var string $thread */
$thread = $modx->getOption('thread', $scriptProperties, '');
if (empty($thread)) {
    $thread = 'resource-' . $modx->resource->get('id');
}

$ratingMax = (float)$modx->getOption('ec_rating_max', $scriptProperties, 5);
$ratingFields = $easyComm->getEcMessageRatingFields();
$itemReviewed = $modx->getOption('itemReviewed', $scriptProperties, '');

$algorithm = $modx->getOption('algorithm', $scriptProperties, 'wilson');
$algorithm = in_array($algorithm, ['simple', 'wilson']) ? $algorithm : 'wilson';

$starWidthAndGup = $modx->getOption('starWidthAndGup', $scriptProperties, '16,4');
list($starWidth, $starsGup) = array_map('floatval', explode(",", $starWidthAndGup));

// Initialize an empty array
$data = array(
    'rating_max' => $ratingMax,
    'itemReviewed' => $itemReviewed,
    'stars_theme' => $modx->getOption('starsTheme', $scriptProperties, 'default'),
    'algorithm' => $algorithm
);
foreach ($ratingFields as $field) {
    $data = array_merge($data, array(
        $field . '_wilson' => 0,
        $field . '_simple' => 0,
        $field . '_wilson_percent' => 0,
        $field . '_simple_percent' => 0,
        $field => 0,
        $field . '_percent' => 0,
    ));
}

/* @var ecThread $thread */
$thread = $modx->getObject('ecThread', array('name' => $thread));
if (!empty($thread)) {
    $data = array_merge($data, $thread->toArray());
    $votes = $thread->getVotes();
    $count = $thread->get('count');
    foreach ($ratingFields as $field) {
        $wilsonPercent = $easyComm->ratingToPercentage($thread->get($field . '_wilson'), $ratingMax, $starWidth, $starsGup);
        $simplePercent = $easyComm->ratingToPercentage($thread->get($field . '_simple'), $ratingMax, $starWidth, $starsGup);
        $percent = $easyComm->ratingToPercentage($thread->get($field . '_' . $algorithm), $ratingMax, $starWidth, $starsGup);

        $data = array_merge($data, array(
            $field . '_wilson_percent' => number_format($wilsonPercent, 3, '.', ''),
            $field . '_simple_percent' => number_format($simplePercent, 3, '.', ''),

            $field => $thread->get($field . '_' . $algorithm),
            $field . '_percent' => number_format($percent, 3, '.', ''),
            // TEST only
            $field . '_votes' => array(),
        ));

        $fieldVotes = array();
        foreach ($votes[$field] as $k => $v) {
            $fieldVotes[$k] = array(
                'count' => $v,
                'volume' => $count ? number_format(($v / $count) * 100.0, 2, '.', '') : 0
            );
        }
        krsort($fieldVotes, SORT_NUMERIC);
        $data[$field . '_votes'] = $fieldVotes;
    }
}

$tpl = $modx->getOption('tpl', $scriptProperties, '');
$fastMode = !empty($fastMode);
$output = $easyComm->getChunk($tpl, $data, $fastMode);

$toPlaceholder = $modx->getOption('toPlaceholder', $scriptProperties, '');
if (!empty($toPlaceholder)) {
    $modx->setPlaceholder($toPlaceholder, $output);
} else {
    return $output;
}
