<?php

class ecMessage extends xPDOSimpleObject
{
    public function updateVoteInfo()
    {
        $q = $this->xpdo->newQuery('ecVote', array('message_id' => $this->get('id')));
        $q->select(array(
            'SUM(value = 1) as likes',
            'SUM(value = -1) as dislikes'
        ));
        $q->limit(1);
        $q->groupby('message_id');

        $data = array('votes' => 0, 'likes' => 0, 'dislikes' => 0, 'votes_rating' => 0);

        if ($q->prepare() && $q->stmt->execute()) {
            $tmp = $q->stmt->fetch(PDO::FETCH_ASSOC);
            if (is_array($tmp)) {
                $data = array_merge($data, $tmp);
            }
            $data['votes'] = $data['likes'] + $data['dislikes'];
            $data['votes_rating'] = $this->calcRating($data['likes'] - $data['dislikes'], $data['votes']);

        }
        $this->fromArray($data);
        $this->save();
    }

    /*
     * See https://habr.com/ru/companies/darudar/articles/143188/
     */
    private function calcRating($sum, $count)
    {
        if ($count <= 0) {
            return 0;
        }
        $maxAllowedRating = 1;
        $minAllowedRating = -1;
        //1.0 = 85%, 1.6 = 95%
        $z = floatval($this->xpdo->getOption('ec_rating_wilson_confidence', null, 1.6));

        $width = (float)$maxAllowedRating - $minAllowedRating;
        $c = (float)$count;
        $phat = ($sum - $c * $minAllowedRating) / $width / $c;
        $rating = ($phat + $z * $z / (2 * $c) - $z * sqrt(($phat * (1 - $phat) + $z * $z / (4 * $c)) / $c)) / (1 + $z * $z / $c);
        //return $rating * $width + $minAllowedRating;
        return $rating;
    }

    /**
     * @return xPDOObject|null
     */
    public function getResource()
    {
        $thread = $this->getOne('Thread');
        if ($thread) {
            return $thread->getOne('Resource');
        }
        return null;
    }

    /**
     * @param array $fileArray
     * @param bool $forceSave
     * @return bool
     */
    public function appendFile($fileArray, $forceSave = false)
    {
        $files = $this->get('files');
        if(!is_array($files)) {
            $files = [];
        }
        $files[] = $fileArray;

        $count = count($files);

        $size = 0;
        foreach ($files as $file) {
            $size += $file['size'];
        }

        $this->set('files', $files);
        $this->set('files_count', $count);
        $this->set('files_size', $size);
        if ($forceSave) {
            $this->save();
        }

        return true;
    }

}