<?php

/**
 * Get a list of ecVotes
 */
class easyCommFileGetListProcessor extends modProcessor {
	//public $permission = 'list';

    /** @var  ecMessage  */
    private $message;

    /** @var easyComm $easyComm */
    protected $easyComm;

    /**
     * Can be used to provide custom methods prior to processing. Return true to tell MODX that the Processor
     * initialized successfully. If you return anything else, MODX will output that return value as an error message.
     *
     * @return boolean
     */
    public function initialize() {
        $this->message = $this->modx->getObject('ecMessage', intval($this->getProperty('message', 0)));
        if (!($this->message instanceof ecMessage)) {
            return false;
        }

        $this->easyComm = $this->modx->getService('easyComm');

        return true;
    }

    /**
     * Run the processor and return the result. Override this in your derivative class to provide custom functionality.
     * Used here for pre-2.2-style processors.
     *
     * @return mixed
     */
    public function process() {
        $limit = intval($this->getProperty('limit'));
        $start = intval($this->getProperty('start'));

        $result = array();
        $total = 0;


        $files = $this->message->get('files');
        if(is_array($files)) {
            $total = count($files);

            for($i = 0; $i < count($files); $i++) {
                if($limit > 0) {
                    if($i < $start){
                        continue;
                    }
                    if($i == $start + $limit) {
                        break;
                    }
                }

                $extension = $files[$i]['extension'];
                $preview = in_array($extension, array('jpg','jpeg','png','gif')) ? $files[$i]['url'] : '';


                $result[] = array_merge($files[$i], array(
                    'idx' => $i,
                    'preview' => $preview,
                    'size_formatted' => $this->easyComm->humanFileSize($files[$i]['size']),
                    'name' => '<a href="'.$files[$i]['url'].'" title="'.$files[$i]['url'].'" target="_blank">'.$files[$i]['name'].'</a>',
                ));
            }
        }

        return $this->outputArray($result, $total);
    }
}

return 'easyCommFileGetListProcessor';