<?php
/**
 * Upload new file
 *
 * @package easyComm
*/

/**
 * Upload files to a directory
 *
 * @param string $docid resource ID
 */
class easyCommFileUploadProcessor extends modProcessor {

    /** @var easyComm $easyComm */
    protected $easyComm;

    /** @var  ecMessage  */
    private $message;

	public function checkPermissions() {
		return $this->modx->hasPermission('ec_message_save');
	}

	public function getLanguageTopics() {
		return array('easycomm');
	}

	public function initialize() {
        $this->message = $this->modx->getObject('ecMessage', intval($this->getProperty('message', 0)));
        if (!($this->message instanceof ecMessage)) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Failed to get message object while uploading files');
            return false;
        }

        if (!$this->easyComm = $this->modx->getService('easyComm')) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Failed to get easyComm service while uploading files');
            return false;
        }

        // Нужно добавить в конфиг сервиса параметры, с которыми была создана цепочка отзывов
        // TODO: !!!
        $properties = $this->message->getOne('Thread')->get('properties');
        $this->easyComm->config = array_merge($this->easyComm->config, $properties);

        return parent::initialize();
	}

    /**
     * Log the removal manager action
     * @return void
     */
    public function logManagerAction() {
        $this->modx->logManagerAction('ecMessage_file_upload', 'ecMessage', $this->message->get('id'));
    }


	public function process() {
        $result = $this->easyComm->mgrUploadFile($this->message);
        if(!$result) {
            return $this->failure('Not all files were uploaded to the server.');
        }

		return $this->success();
	}

}

return 'easyCommFileUploadProcessor';