<?php

/**
 * Remove an ecMessage
 */
class easyCommMessageRemoveProcessor extends modObjectRemoveProcessor {
    /** @var ecMessage $object */
    public $object;
	public $objectType = 'ecMessage';
	public $classKey = 'ecMessage';
	public $languageTopics = array('easycomm');
	public $permission = 'ec_message_remove';

    public $beforeRemoveEvent = 'OnBeforeEcMessageRemove';
    public $afterRemoveEvent = 'OnEcMessageRemove';

    /**
     * @return bool
     */
    public function beforeRemove() {
        /** @var easyComm $easyComm */
        $easyComm = $this->modx->getService('easyComm');

        try {
            $context = $this->object->getOne('Thread')->getOne('Resource')->get('context_key');
            $mediaManager = $easyComm->getMediaManager($context);
        } catch (Exception $e) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Failed to get media manager object while deleting files');
            return $this->failure($this->modx->lexicon('ec_message_file_err_remove'));
        }

        // remove files from media source
        $files = $this->object->get('files');
        if(is_array($files)) {
            foreach ($files as $file) {
                $mediaManager->removeObject($file['path']);
                if(!empty($file['thumb_path'])) {
                    $mediaManager->removeObject($file['thumb_path']);
                }
            }
        }

        return parent::beforeRemove();
    }

    /**
     * @return bool
     */
    public function afterRemove() {
        /** @var ecThread $thread */
        if ($thread = $this->object->getOne('Thread')) {
            $thread->updateMessagesInfo();
        }
        return parent::afterRemove();
    }

    /**
     * Log the removal manager action
     * @return void
     */
    public function logManagerAction()
    {
        $this->modx->logManagerAction($this->objectType . '_remove', $this->classKey, $this->object->get($this->primaryKeyField));
    }

}

return 'easyCommMessageRemoveProcessor';