<?php

/**
 * Publish an ecMessage
 */
class easyCommReplyPublishProcessor extends modObjectUpdateProcessor
{
    /** @var ecMessage $object */
    public $object;
    public $objectType = 'ecReply';
    public $classKey = 'ecReply';
    public $languageTopics = array('easycomm');
    public $permission = 'ec_message_publish';

    public $beforeSaveEvent = 'OnBeforeEcReplyPublish';
    public $afterSaveEvent = 'OnEcReplyPublish';

    /**
     * @return bool
     */
    public function beforeSave()
    {
        $this->object->fromArray(array(
            'published' => 1,
            'published_on' => date('Y-m-d H:i:s'),
            'published_by' => $this->modx->user->get('id'),
        ));
        return parent::beforeSave();
    }

    /**
     * @return bool
     */
    public function afterSave()
    {
        if($this->object->get('published') && !$this->object->get('notify_date')) {
            $notifier = new easyCommNotifier($this->modx);
            $notifier->notify($this->object, false, true, true);

            $this->object->set('notify_date', date('Y-m-d H:i:s'));
            $this->object->save();
        }
        return parent::afterSave();
    }

    /**
     * Log the removal manager action
     * @return void
     */
    public function logManagerAction()
    {
        $this->modx->logManagerAction($this->objectType . '_publish', $this->classKey, $this->object->get($this->primaryKeyField));
    }
}

return 'easyCommReplyPublishProcessor';