<?php

/**
 * Create an ecThread
 */
class easyCommThreadCreateProcessor extends modObjectCreateProcessor {
	public $objectType = 'ecThread';
	public $classKey = 'ecThread';
	public $languageTopics = array('easycomm');
	public $permission = 'ec_thread_save';


	/**
	 * @return bool
	 */
	public function beforeSet() {
		$name = trim($this->getProperty('name'));
		if (empty($name)) {
			$this->modx->error->addField('name', $this->modx->lexicon('ec_thread_err_name'));
		}
		elseif ($this->modx->getCount($this->classKey, array('name' => $name))) {
			$this->modx->error->addField('name', $this->modx->lexicon('ec_thread_err_ae'));
		}

		return parent::beforeSet();
	}

}

return 'easyCommThreadCreateProcessor';