<?php

/**
 * Update an ecVote
 */
class easyCommVoteUpdateProcessor extends modObjectUpdateProcessor {
	public $objectType = 'ecVote';
	public $classKey = 'ecVote';
	public $languageTopics = array('easycomm');
	//public $permission = 'ec_vote_save';

    public $beforeSaveEvent = '';
    public $afterSaveEvent = '';

    /** @var ecVote $object */
    public $object;

    /** @var easyComm $easyComm */
    protected $easyComm;

    /**
     * @return bool
     */
    public function initialize() {
        /** @var easyComm $easyComm */
        $this->easyComm = $this->modx->getService('easyComm');
        $this->easyComm->initialize($this->modx->context->key);

        return parent::initialize();
    }

	/**
	 * @return bool
	 */
	public function beforeSet() {
		$id = (int)$this->getProperty('id');

		if (empty($id)) {
			return $this->modx->lexicon('ec_message_err_ns');
		}

        // IP, session
        $ip = $this->easyComm->getClientIp();
        $session = session_id();

        $now = date('Y-m-d H:i:s');
        $this->setProperties(array(
            'ip' => $ip,
            'session' => $session,
            'updated_on' => $now,
            'value' => ($this->getProperty('value') > 0 ? 1 : -1)
        ));

		return parent::beforeSet();
	}

    /** {@inheritDoc} */
    public function afterSave() {
        /** @var ecMessage $message */
        if ($message = $this->object->getOne('Message')) {
            $message->updateVoteInfo();
        }

        return parent::afterSave();
    }
}

return 'easyCommVoteUpdateProcessor';