<?php

/**
 * Create an ecReply
 */
class easyCommReplyWebCreateProcessor extends modObjectCreateProcessor
{
    public $objectType = 'ecReply';
    public $classKey = 'ecReply';
    public $languageTopics = array('easycomm');
    //public $permission = 'create';

    public $beforeSaveEvent = 'OnBeforeEcReplySave';
    public $afterSaveEvent = 'OnEcReplySave';

    /** @var ecReply $object */
    public $object;

    /** {@inheritDoc} */
    public function beforeSet()
    {
        /** @var EasyComm $easyComm */
        $easyComm = $this->modx->getService('easyComm');

        $thread = $this->modx->getObject('ecThread', $this->getProperty('thread_id'));
        $message = $this->modx->getObject('ecMessage', $this->getProperty('message_id'));

        // Проверим, что цепочка и сообщение существуют и соответствуют друг другу
        if (!$thread || !$message || $message->get('thread_id') !== $thread->get('id')) {
            $this->modx->error->addField('thread_id', $this->modx->lexicon('ec_reply_err_thread'));
            return false;
        }
        $requiredFields = $this->getProperty('requiredFields', null);

        if ($requiredFields) {
            foreach ($requiredFields as $rf) {
                $p = $this->getProperty($rf);
                if (empty($p)) {
                    $this->modx->error->addField($rf, $this->modx->lexicon('ec_reply_err_' . $rf));
                }
            }
        }

        $emailField = 'user_email';
        $emailFieldValue = $this->getProperty('user_email');
        if ($this->getProperty('validateEmail') && !empty($emailFieldValue)) {
            if (!easyCommValidator::isValidEmail($emailFieldValue)) {
                $this->modx->error->addField($emailField, $this->modx->lexicon('ec_reply_err_validate_' . $emailField));
            }
        }

        // Если нет иных ошибок - проверяем на спам
        // в противном случае возникают проблемы при вторичной проверке формы
        if (!$this->modx->error->hasError()) {
            if (!$easyComm->verifyCaptcha()) {
                $this->modx->error->addField('captcha', $this->modx->lexicon('ec_fe_err_captcha'));
            }
        }

        $now = date('Y-m-d H:i:s');
        $ip = $this->modx->request->getClientIp();
        $this->setProperties(array(
            'thread_id' => $message->get('thread_id'),
            'ip' => $ip['ip'],
            'created_on' => $now,
            'created_by' => $this->modx->user->isAuthenticated($this->modx->context->key) ? $this->modx->user->id : 0,
        ));
        if ($this->getProperty('published')) {
            $this->setProperties(array(
                'published_on' => $now,
                'published_by' => $this->modx->user->isAuthenticated($this->modx->context->key) ? $this->modx->user->id : 0,
            ));
        }
        return parent::beforeSet();
    }

    /** {@inheritDoc} */
    public function afterSave()
    {
        // TODO:
        // Возможно, придется добавить к цепочке кол-во ответов, нужно подумать.
        // Или к сообщению кол-во ответов.
        //$this->thread->updateMessagesInfo();
        return parent::afterSave();
    }

}

return 'easyCommReplyWebCreateProcessor';