<?php

if (!class_exists('easyCommManagerController')) {
    require_once dirname(__FILE__) . '/base.class.php';
}

/**
 * The home manager controller for easyComm.
 *
 */
class easyCommHomeManagerController extends easyCommManagerController
{

    /**
     * @return null|string
     */
    public function getPageTitle()
    {
        return $this->modx->lexicon('easycomm');
    }

    /**
     * @return string
     */
    public function getTemplateFile()
    {
        return $this->easyComm->config['templatesPath'] . 'home.tpl';
    }

    /**
     * @return void
     */
    public function loadCustomCssJs()
    {
        $this->addCss($this->easyComm->config['cssUrl'] . 'mgr/main.css');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/misc/utils.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/threads.grid.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/threads.windows.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/messages.grid.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/messages.windows.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/replies.grid.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/replies.windows.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/reply-templates.grid.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/reply-templates.windows.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/files.grid.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/votes.grid.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/home.panel.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/sections/home.js');
        $this->addHtml('<script type="text/javascript">
		Ext.onReady(function() {
			MODx.load({ xtype: "ec-page-home"});
		});
		</script>');
    }

    /**
     * @param array $scriptProperties
     */
    public function process(array $scriptProperties = array())
    {
        if ($this->modx->getOption('ec_use_rte')) {
            $this->loadRichTextEditor();
        }
    }


    public function loadRichTextEditor()
    {
        $useEditor = $this->modx->getOption('use_editor');
        $whichEditor = $this->modx->getOption('which_editor');
        if ($useEditor && !empty($whichEditor)) {
            // invoke the OnRichTextEditorInit event
            $onRichTextEditorInit = $this->modx->invokeEvent('OnRichTextEditorInit', array(
                'editor' => $whichEditor, // Not necessary for Redactor
                'elements' => array('foo'), // Not necessary for Redactor
            ));
            /*if (is_array($onRichTextEditorInit))
            {
                $onRichTextEditorInit = implode('', $onRichTextEditorInit);
            }*/
            //$this->setPlaceholder('onRichTextEditorInit', $onRichTextEditorInit);
        }
    }

}