<?php

if (!class_exists('easyCommManagerController')) {
    require_once dirname(__FILE__) . '/base.class.php';
}


/**
 * The home manager controller for easyComm.
 *
 */
class easyCommSettingsManagerController extends easyCommManagerController
{
    /**
     * @return null|string
     */
    public function getPageTitle()
    {
        return $this->modx->lexicon('ec_settings') . ' | ' . $this->modx->lexicon('easycomm');
    }

    /**
     * @return string
     */
    public function getTemplateFile()
    {
        return $this->easyComm->config['templatesPath'] . 'settings.tpl';
    }

    /**
     * @return void
     */
    public function loadCustomCssJs()
    {
        $this->addCss($this->easyComm->config['cssUrl'] . 'mgr/main.css');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/misc/utils.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/reply-templates.grid.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/widgets/reply-templates.windows.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/settings/settings.panel.js');
        $this->addJavascript($this->easyComm->config['jsUrl'] . 'mgr/settings/settings.js');
        $this->addHtml('<script type="text/javascript">
		Ext.onReady(function() {
			MODx.load({ xtype: "ec-page-settings"});
		});
		</script>');
    }


}