<?php

/** @var modX $modx */
/** @var easyComm $easyComm */
/** @var array $scriptProperties */
if (!$easyComm = $modx->getService('easyComm', 'easyComm', $modx->getOption('ec_core_path', null, $modx->getOption('core_path') . 'components/easycomm/') . 'model/easycomm/', $scriptProperties)) {
    return 'Could not load easyComm class!';
}
$easyComm->initialize($modx->context->key, $scriptProperties);

$tplForm = $modx->getOption('tplForm', $scriptProperties, 'tpl.ecReplyForm');
$threadName = $modx->getOption('thread', $scriptProperties, '');
if (empty($threadName)) {
    $threadName = 'resource-' . $modx->resource->get('id');
    $scriptProperties['thread'] = $threadName;
}

// Create ecThread object if it doesn't exist
/** @var ecThread $ecThread */
if (!$ecThread = $modx->getObject('ecThread', ['name' => $threadName])) {
    $modx->log(modX::LOG_LEVEL_ERROR, '[EasyComm] You must call the ecForm snippet before ecReplyForm!');
    return '';
}

$properties = $ecThread->get('properties');
if(!is_array($properties) || array_key_exists('thread', $properties)) {
    $properties = [];
}
$properties['ecReplyForm'] = $scriptProperties;
$ecThread->set('properties', $properties);
$ecThread->save();

$data = [
    'fid' => 'ec-reply-form-' . $ecThread->get('name'),
    'thread' => $ecThread->get('name'),
    'antispam_field' => $modx->getOption('antispamField', $scriptProperties)
];

if ($modx->user->hasSessionContext($modx->context->get('key'))) {
    $profile = $modx->user->getOne('Profile');
    $data['user_name'] = $profile->get('fullname');
    if (empty($data['user_name'])) {
        $data['user_name'] = $modx->user->get('username');
    }
    $data['user_email'] = $profile->get('email');
}

$data['agreementCheckbox'] = $modx->getOption('agreementCheckbox', $scriptProperties, 1);

if ($modx->getOption('ec_captcha_enable')) {
    $tplFormReCaptcha = $modx->getOption('tplFormReCaptcha', $scriptProperties, 'tpl.ecForm.ReCaptcha');
    $data['recaptcha'] = $easyComm->getChunk($tplFormReCaptcha, $data);
}

return $easyComm->getChunk($tplForm, $data);
