<?php

/**
 * Create an ecMessage
 */
class easyCommMessageCreateProcessor extends modObjectCreateProcessor
{
    public $objectType = 'ecMessage';
    public $classKey = 'ecMessage';
    public $languageTopics = array('easycomm');
    public $permission = 'ec_message_save';

    public $beforeSaveEvent = 'OnBeforeEcMessageSave';
    public $afterSaveEvent = 'OnEcMessageSave';

    /** @var ecMessage $object */
    public $object;

    /** @var ecThread $thread */
    private $thread;

    /**
     * @return bool
     */
    public function beforeSet()
    {
        $threadId = $this->getProperty('thread_id');
        /** @var easyComm $easyComm */
        $easyComm = $this->modx->getService('easyComm');

        if (!$this->thread = $this->modx->getObject('ecThread', $threadId)) {
            $this->modx->error->addField('thread_id', $this->modx->lexicon('ec_message_err_thread'));
        }

        $ratingMax = intval($this->modx->getOption('ec_rating_max'));
        $ratingFields = $easyComm->getEcMessageRatingFields();
        foreach ($ratingFields as $field) {
            $value = intval($this->getProperty($field));
            if ($value < 0) {
                $value = 0;
            }
            if ($value > $ratingMax) {
                $value = $ratingMax;
            }
            $this->setProperty($field, $value);
        }

        $now = date('Y-m-d H:i:s');

        $date = $this->getProperty('date');
        if (empty($date)) {
            $this->setProperty('date', $now);
        }

        $this->setProperties(array(
            'created_on' => $now,
            'created_by' => $this->modx->user->isAuthenticated($this->modx->context->key) ? $this->modx->user->id : 0,
            'edited_on' => null,
            'edited_by' => 0
        ));
        if ($this->getProperty('published')) {
            $this->setProperties(array(
                'published_on' => $now,
                'published_by' => $this->modx->user->isAuthenticated($this->modx->context->key) ? $this->modx->user->id : 0,
            ));
        }
        return parent::beforeSet();
    }

    /** {@inheritDoc} */
    public function afterSave()
    {
        $this->thread->updateMessagesInfo();

        if ($this->object->get('notify')
            || (!$this->object->get('notify_date') && $this->object->get('published'))) {
            $notifier = new easyCommNotifier($this->modx);
            $notifier->notify($this->object, false, true, false);

            $this->object->set('notify', 0);
            $this->object->set('notify_date', date('Y-m-d H:i:s'));
            $this->object->save();
        }

        return parent::afterSave();
    }

}

return 'easyCommMessageCreateProcessor';