<?php

/**
 * Get a list of ecMessage
 */
class easyCommReplyGetListProcessor extends modObjectGetListProcessor
{
    public $objectType = 'ecReply';
    public $classKey = 'ecReply';
    public $defaultSortField = 'id';
    public $defaultSortDirection = 'DESC';
    //public $permission = 'list';

    /**
     * @param xPDOQuery $c
     *
     * @return xPDOQuery
     */
    public function prepareQueryBeforeCount(xPDOQuery $c)
    {
        $c->leftJoin('ecThread', 'Thread', '`ecReply`.`thread_id` = `Thread`.`id`');
        $c->leftJoin('modResource', 'Resource', '`Thread`.`resource_id` = `Resource`.`id`');

        $c->select($this->modx->getSelectColumns($this->classKey, 'ecReply', ''));
        $c->select($this->modx->getSelectColumns('ecThread', 'Thread', 'thread_', ['resource_id', 'name', 'title']));
        $c->select($this->modx->getSelectColumns('modResource', 'Resource', 'resource_', ['id', 'pagetitle', 'context_key']));

        $c = $this->addCommonCriteria($c);

        $query = trim($this->getProperty('query'));
        if ($query) {
            $c->where(array(
                'user_name:LIKE' => "%{$query}%",
                'OR:user_email:LIKE' => "%{$query}%",
                'OR:text:LIKE' => "%{$query}%"
            ));
        }

        return $c;
    }

    private function addCommonCriteria(xPDOQuery $c)
    {
        $resource_id = intval($this->getProperty('resource_id'));
        if (!empty($resource_id)) {
            $c->where(array('`Thread`.`resource_id`' => $resource_id));
        }
        $thread_id = intval($this->getProperty('thread_id'));
        if (!empty($message_id)) {
            $c->where(array('`Thread`.`id`' => $thread_id));
        }
        $message_id = intval($this->getProperty('message_id'));
        if (!empty($message_id)) {
            $c->where(array('message_id' => $message_id));
        }
        return $c;
    }

    /**
     * @param xPDOObject $object
     *
     * @return array
     */
    public function prepareRow(xPDOObject $object)
    {
        $array = $object->toArray();

        if (!empty($array['resource_id'])) {
            $array['preview_url'] = $this->modx->makeUrl($array['resource_id'], $array['resource_context_key']);
        }

        return $array;
    }

    /** {@inheritDoc} */
    public function outputArray(array $array, $count = false)
    {
        if ($count === false) {
            $count = count($array);
        }
        $output = json_encode(array(
            'success' => true,
            'total' => $count,
            'results' => $array,
            'new' => $this->getCountOfNewReplies()
        ));
        if ($output === false) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Processor failed creating output array due to JSON error ' . json_last_error());
            return json_encode(array('success' => false));
        }
        return $output;
    }

    private function getCountOfNewReplies()
    {
        $c = $this->modx->newQuery($this->classKey);
        $c->leftJoin('ecThread', 'Thread', '`ecReply`.`thread_id` = `Thread`.`id`');
        $c->select($this->modx->getSelectColumns($this->classKey, $this->objectType, ''));
        $c->where([
            'ecReply.published' => false
        ]);

        $c = $this->addCommonCriteria($c);
        return $this->modx->getCount($this->classKey, $c);
    }

}

return 'easyCommReplyGetListProcessor';