<?php

/**
 * Publish an ecReply
 */
class easyCommReplyUnPublishProcessor extends modObjectUpdateProcessor {
    /** @var ecReply $object */
    public $object;
    public $objectType = 'ecReply';
    public $classKey = 'ecReply';
    public $languageTopics = array('easycomm');
    public $permission = 'ec_message_publish';

    public $beforeSaveEvent = 'OnBeforeEcReplyUnPublish';
    public $afterSaveEvent = 'OnEcReplyUnPublish';


    /**
     * @return bool
     */
    public function beforeSave()
    {
        $this->object->fromArray(array(
            'published' => 0,
            'published_on' => null,
            'published_by' => 0,
        ));
        return parent::beforeSave();
    }

    /**
     * Log the removal manager action
     * @return void
     */
    public function logManagerAction()
    {
        $this->modx->logManagerAction($this->objectType . '_unpublish', $this->classKey, $this->object->get($this->primaryKeyField));
    }
}

return 'easyCommReplyUnPublishProcessor';
