<?php

/**
 * Get a list of ecThread for combobox
 */
class easyCommThreadGetComboListProcessor extends modObjectGetListProcessor {
	public $objectType = 'ecThread';
	public $classKey = 'ecThread';
	public $defaultSortField = 'id';
	public $defaultSortDirection = 'DESC';
	//public $permission = 'list';


    public function prepareQueryBeforeCount(xPDOQuery $c) {
        $c->leftJoin('modResource', 'Resource', '`ecThread`.`resource_id` = `Resource`.`id`');

        $c->select($this->modx->getSelectColumns($this->classKey, 'ecThread', '', ['id', 'name', 'title']));
        $c->select($this->modx->getSelectColumns('modResource', 'Resource', 'resource_', ['id', 'pagetitle']));

        $query = $this->getProperty('query');
        if (!empty($query)) {
            $c->where(array(
                'ecThread.name:LIKE' => '%' . $query . '%',
                'OR:ecThread.title:LIKE' => "%{$query}%",
                'OR:Resource.pagetitle:LIKE' => "%{$query}%",
            ));
        }
        return $c;
    }
    /** {@inheritDoc} */
    public function prepareRow(xPDOObject $object) {
        $title = $object->get('title');
        if (empty($title)) {
            $title = $object->get('name');
        } else {
            $title = sprintf('%s (%s)', $object->get('name'), $title);
        }

        $title = sprintf('%s | %s (%d)', $title, $object->get('resource_pagetitle'),$object->get('resource_id'));

        return ['id' => $object->get('id'), 'title' => $title];
    }

}

return 'easyCommThreadGetComboListProcessor';