<?php

/**
 * Create an ecVote
 */
class easyCommVoteCreateProcessor extends modObjectCreateProcessor {
    public $objectType = 'ecVote';
    public $classKey = 'ecVote';
    public $languageTopics = array('easycomm');
    //public $permission = 'ec_vote_save';

    public $beforeSaveEvent = '';
    public $afterSaveEvent = '';

    /** @var ecMessage $object */
    public $object;

    /** @var easyComm $easyComm */
    protected $easyComm;

    /**
     * @return bool
     */
    public function initialize() {
        /** @var easyComm $easyComm */
        $this->easyComm = $this->modx->getService('easyComm');
        $this->easyComm->initialize($this->modx->context->key);

        return parent::initialize();
    }

    /**
     * @return bool
     */
    public function beforeSet() {
        $messageId = $this->getProperty('message_id');

        if (!$message = $this->modx->getObject('ecMessage', $messageId)) {
            $this->modx->error->addField('message_id', $this->modx->lexicon('ec_vote_err_message'));
        }

        // IP, session
        $ip = $this->easyComm->getClientIp();
        $session = session_id();

        $now = date('Y-m-d H:i:s');
        $this->setProperties(array(
            'ip' => $ip,
            'session' => $session,
            'created_on' => $now,
            'created_by' => $this->modx->user->id,
            'value' => ($this->getProperty('value') > 0 ? 1 : -1)
        ));

        if($this->modx->user->get('id')) {
            if($this->modx->getCount($this->classKey, array('message_id' => $message->get('id'), 'created_by' => $this->modx->user->get('id')))){
                $this->modx->error->addField('value', $this->modx->lexicon('ec_vote_err_ae'));
            }
        } else {
            // По идее здесь нужна проверка на сессию и IP, чтобы не создавать дубли.
            // Но эта проверка уже есть в процессоре message/vote, исходя из нее принимается решение о вызове create или update процессора
            // По этой же логике можно убрать и проверку на пользователя парой строк выше

            /*if($this->modx->getCount($this->classKey, array('message_id' => $message->get('id'), 'created_by' => 0, 'ip' => $ip))){
                $this->modx->error->addField('value', $this->modx->lexicon('ec_vote_err_ae'));
            }
            if($this->modx->getCount($this->classKey, array('message_id' => $message->get('id'), 'created_by' => 0, 'session' => $session))){
                $this->modx->error->addField('value', $this->modx->lexicon('ec_vote_err_ae'));
            }*/
        }

        return parent::beforeSet();
    }

    /** {@inheritDoc} */
    public function afterSave() {
        /** @var ecMessage $message */
        if ($message = $this->object->getOne('Message')) {
            $message->updateVoteInfo();
        }

        return parent::afterSave();
    }

}

return 'easyCommVoteCreateProcessor';