<?php

class efFieldAbsCreateProcessor extends modObjectCreateProcessor
{
    public $classKey = efFieldAbs::class;
    public $objectType = 'ef_field';
    public $languageTopics = ['extrafields'];


    /**
     * @return bool
     */
    public function beforeSet()
    {
        if (!empty($this->properties['ab_templates'])) {
            $this->properties['ab_templates'] = implode('||', $this->properties['ab_templates']);
        }
        if (!empty($this->properties['ab_user_group'])) {
            $this->properties['ab_user_group'] = implode('||', $this->properties['ab_user_group']);
        }

        return true;
    }


    /**
     * @return bool
     */
    public function beforeSave()
    {
        $this->object->fromArray([
            'menuindex' => $this->modx->getCount($this->classKey),
        ]);

        return true;
    }

}

return 'efFieldAbsCreateProcessor';