<?php

namespace Boshnik\ExtraFields\Events;

/**
 * class OnManagerPageInit
 */
class OnManagerPageInit extends Event
{
    public function run()
    {
        $this->modx->controller->addHtml("<script> 
            MODx.clientconfig = ". json_encode($this->getClientConfigs()) .";
        </script>");
    }


    public function getClientConfigs()
    {
        $configs = [];
        if (!$this->extrafields->getPackage('ClientConfig')) {
            return $configs;
        }

        $contexts = $this->modx->getIterator(modContext::class);
        foreach ($contexts as $context) {
            if ($context->key != 'mgr') {
                $configx[$context->key] = [];
            }
        }

        $q = $this->modx->newQuery(cgContextValue::class);
        $q->leftJoin(cgSetting::class, 'cgSetting', 'cgContextValue.setting = cgSetting.id');
        $q->select($this->modx->getSelectColumns(cgContextValue::class, cgContextValue::class, '', '', false));
        $q->select([
            'cgSetting.key as setting',
        ]);
        $q->prepare();
        $q->stmt->execute();
        $results = $q->stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($results as $config) {
            $configs[$config['context']][$config['setting']] = $config['value'];
        }

        return $configs;
    }
}