<?php

/**
 * The home manager controller for msOrderFields.
 *
 */
class msOrderFieldsHomeManagerController extends modExtraManagerController
{
    /** @var msOrderFields $msOrderFields */
    public $msOrderFields;


    /**
     *
     */
    public function initialize()
    {
        $this->msOrderFields = $this->modx->getService('msOrderFields', 'msOrderFields', MODX_CORE_PATH . 'components/msorderfields/model/');
        parent::initialize();
    }


    /**
     * @return array
     */
    public function getLanguageTopics()
    {
        return ['msorderfields:default'];
    }


    /**
     * @return bool
     */
    public function checkPermissions()
    {
        return true;
    }


    /**
     * @return null|string
     */
    public function getPageTitle()
    {
        return $this->modx->lexicon('msorderfields');
    }


    /**
     * @return void
     */
    public function loadCustomCssJs()
    {
        $this->addCss($this->msOrderFields->config['cssUrl'] . 'mgr/main.css');
        $this->addJavascript($this->msOrderFields->config['jsUrl'] . 'mgr/msorderfields.js');
        $this->addJavascript($this->msOrderFields->config['jsUrl'] . 'mgr/misc/utils.js');
        $this->addJavascript($this->msOrderFields->config['jsUrl'] . 'mgr/misc/combo.js');
        $this->addJavascript($this->msOrderFields->config['jsUrl'] . 'mgr/misc/default.grid.js');
        $this->addJavascript($this->msOrderFields->config['jsUrl'] . 'mgr/widgets/fields/grid.js');
        $this->addJavascript($this->msOrderFields->config['jsUrl'] . 'mgr/widgets/fields/windows.js');
        $this->addJavascript($this->msOrderFields->config['jsUrl'] . 'mgr/widgets/groups/grid.js');
        $this->addJavascript($this->msOrderFields->config['jsUrl'] . 'mgr/widgets/groups/windows.js');
        $this->addJavascript($this->msOrderFields->config['jsUrl'] . 'mgr/widgets/home.panel.js');
        $this->addJavascript($this->msOrderFields->config['jsUrl'] . 'mgr/sections/home.js');

        $this->addHtml('<script>
        msOrderFields.config = ' . json_encode($this->msOrderFields->config) . ';
        msOrderFields.config.connector_url = "' . $this->msOrderFields->config['connectorUrl'] . '";
        Ext.onReady(function() {MODx.load({ xtype: "msorderfields-page-home"});});
        </script>');
    }


    /**
     * @return string
     */
    public function getTemplateFile()
    {
        $this->content .= '<div id="msorderfields-panel-home-div"></div>';

        return '';
    }
}