<?php

class msOrderFields
{
    /** @var modX $modx */
    public $modx;

    public $status = false;

    public $fieldmeta = [
        'textfield' => [
            'dbtype' => 'varchar',
            'precision' => '255',
            'phptype' => 'string',
            'null' => true,
            'default' => null,
        ],
        'textarea' => [
            'dbtype' => 'text',
            'phptype' => 'string',
            'null' => true,
            'default' => null,
        ],
        'richtext' => [
            'dbtype' => 'text',
            'phptype' => 'string',
            'null' => true,
            'default' => null,
        ],
        'numberfield' => [
            'dbtype' => 'int',
            'precision' => 10,
            'attributes' => 'unsigned',
            'phptype' => 'integer',
            'null' => true,
            'default' => 0,
        ],
        'xcheckbox' => [
            'dbtype' => 'tinyint',
            'precision' => 1,
            'attributes' => 'unsigned',
            'phptype' => 'integer',
            'null' => true,
            'default' => 0,
        ],
        'msorderfields-combo-boolean' => [
            'dbtype' => 'tinyint',
            'precision' => 1,
            'attributes' => 'unsigned',
            'phptype' => 'boolean',
            'null' => false,
            'default' => 0,
        ],
        'datefield' => [
            'dbtype' => 'int',
            'precision' => 20,
            'phptype' => 'date',
            'null' => true,
            'default' => null,
        ],
        'timefield' => [
            'dbtype' => 'varchar',
            'precision' => '255',
            'phptype' => 'string',
            'null' => true,
            'default' => null,
        ],
        'minishop2-xdatetime' => [
            'dbtype' => 'int',
            'precision' => 20,
            'phptype' => 'timestamp',
            'null' => true,
            'default' => null,
        ],
        'displayfield' => [
            'dbtype' => 'varchar',
            'precision' => '255',
            'phptype' => 'string',
            'null' => true,
            'default' => null,
        ],
        'minishop2-combo-chunk' => [
            'dbtype' => 'varchar',
            'precision' => '255',
            'phptype' => 'string',
            'null' => true,
            'default' => null,
        ],
        'minishop2-combo-browser' => [
            'dbtype' => 'varchar',
            'precision' => '255',
            'phptype' => 'string',
            'null' => true,
            'default' => null,
        ],
    ];


    /**
     * @param modX $modx
     * @param array $config
     */
    function __construct(modX &$modx, array $config = [])
    {
        $this->modx =& $modx;
        $corePath = MODX_CORE_PATH . 'components/msorderfields/';
        $assetsUrl = MODX_ASSETS_URL . 'components/msorderfields/';

        $this->config = array_merge([
            'corePath' => $corePath,
            'modelPath' => $corePath . 'model/',
            'processorsPath' => $corePath . 'processors/',

            'connectorUrl' => $assetsUrl . 'connector.php',
            'assetsUrl' => $assetsUrl,
            'cssUrl' => $assetsUrl . 'css/',
            'jsUrl' => $assetsUrl . 'js/',
        ], $config);

        $this->modx->addPackage('msorderfields', $corePath . 'model/');
        $this->modx->lexicon->load('msorderfields:default');

        $this->status = $this->modx->getObject('transport.modTransportPackage', ['package_name' => 'miniShop2', 'installed:!=' => null]);
    }


    public function initialize()
    {
        if(!$this->status) return false;
        $this->modx->loadClass('msOrderAddress');
        $fields = $this->getData('OrderFields', ['active' => 1, 'editable' => 1]);
        foreach ($fields as $field) {
            $map = $this->fieldmeta[$field['xtype']];
            $this->modx->map['msOrderAddress']['fields'][$field['name']] = $map['default'];
            $this->modx->map['msOrderAddress']['fieldMeta'][$field['name']] = $map;
        }

        $this->modx->loadClass('msOrder');
        $this->modx->map['msOrder']['fields']['discount'] = 0;
        $this->modx->map['msOrder']['fieldMeta']['discount'] = [
            'dbtype' => 'decimal',
            'precision' => '12,2',
            'phptype' => 'float',
            'null' => true,
            'default' => 0,
        ];
    }

    public function runProcessor($action = '', $data = array())
    {
        if (empty($action)) {
            return false;
        }
        $this->modx->error->reset();
        $processorsPath = !empty($this->config['processorsPath'])
            ? $this->config['processorsPath']
            : MODX_CORE_PATH . 'components/msorderfields/processors/';

        return $this->modx->runProcessor($action, $data, array(
            'processors_path' => $processorsPath,
        ));
    }

    /**
     * @param modSystemEvent $event
     * @param array $scriptProperties
     */
    public function handleEvent(modSystemEvent $event, array $scriptProperties)
    {
        if(!$this->status) return false;
        extract($scriptProperties);
        switch ($event->name) {
            case 'msOnManagerCustomCssJs':
                if ($page == 'orders') {
                    // Добавляем стили
                    $this->modx->controller->addHtml('<script>
                        var msOrderFields = {};
                        msOrderFields.combo = {};
                        msOrderFields.config = {};
                        msOrderFields.config.url = "' . $this->config['connectorUrl'] . '";
                        msOrderFields.groups = '.json_encode($this->getData("OrderGroups")).';
                        msOrderFields.fields = '.json_encode($this->getData()).';
                    </script>');
                    $this->modx->controller->addLastJavascript($this->config['jsUrl'] . 'mgr/order.js');
                    $this->modx->controller->addHTML('<style>
                        #minishop2-window-order-update.x-window { z-index:999!important }
                        #minishop2-window-order-update.x-window .panel-desc { margin-top: 15px }
                    </style>');

                    $this->loadRTE($scriptProperties);
                }
                break;
            case  'msOnBeforeUpdateOrder':
                $cost = $object->get('cart_cost') - $object->get('discount') + $object->get('delivery_cost');
                $object->set('cost', $cost);
                $object->save();
                break;
        }
    }

    public function loadRTE($scriptProperties)
    {
        // Подключаем редактор
        if ($this->modx->getOption('which_editor') == 'TinyMCE RTE') {

            $corePath = $this->modx->getOption('tinymcerte.core_path', null, $this->modx->getOption('core_path') . 'components/tinymcerte/');
            /** @var TinyMCERTE $tinymcerte */
            $this->tinymcerte = $this->modx->getService('tinymcerte', 'TinyMCERTE', $corePath . 'model/tinymcerte/', [
                'core_path' => $corePath
            ]);

            $classes = ['OnRichTextEditorInit'];

            if ($this->tinymcerte) {
                foreach($classes as $className) {
                    $className = 'TinyMCERTE\Plugins\Events\\' . $className;
                    if (class_exists($className)) {
                        $handler = new $className($this->modx, $scriptProperties);
                        if (get_class($handler) == $className) {
                            $handler->run();
                        }
                    }
                }
            }

        }
    }

    public function getData($classKey = 'OrderFields', $where = ['active' => 1])
    {
        $query = $this->modx->newQuery($classKey);
        $query->select($this->modx->getSelectColumns($classKey));
        $query->where($where);
        $query->sortby('rank', 'asc');
        $query->prepare();
        $query->stmt->execute();
        return $query->stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function ms2Lexicon($object = [], $update = true)
    {
        if(!isset($object['name']) || empty($object['name'])) return;
        $lang = $this->modx->getOption('manager_language', '', 'ru');

        $lexicons = ['ms2_' => 'lexicon', 'ms2_frontend_' => 'lexicon_frontend'];
        foreach($lexicons as $name => $value) {
            $where = [
                'namespace' => 'minishop2',
                'topic' => $name == 'ms2_' ? 'manager' : 'default',
                'language' => $lang,
                'name' => $name . $object['name'],
            ];
            if(!$lexicon = $this->modx->getObject('modLexiconEntry', $where)) {
                if($update) $lexicon = $this->modx->newObject('modLexiconEntry', $where);
            }
            if($update) {
                $lexicon->set('value', $object[$value]);
                $lexicon->save();
            } else {
                $lexicon->remove();
            }
        }
    }

    public function sendEmail($message,array $options = array()) {

        $this->modx->getService('mail', 'mail.modPHPMailer');
        if (!$this->modx->mail) return false;

        $this->modx->mail->set(modMail::MAIL_BODY, $message);
        $this->modx->mail->set(modMail::MAIL_FROM, $this->modx->getOption('from',$options,$this->modx->getOption('emailsender')));
        $this->modx->mail->set(modMail::MAIL_FROM_NAME, $this->modx->getOption('fromName',$options,$this->modx->getOption('site_name')));
        $this->modx->mail->set(modMail::MAIL_SENDER, $this->modx->getOption('sender',$options,$this->modx->getOption('emailsender')));
        $this->modx->mail->set(modMail::MAIL_SUBJECT, $this->modx->getOption('subject',$options,$this->modx->getOption('emailsubject')));
        $this->modx->mail->address('to',$this->modx->getOption('email',$options, $this->modx->getOption('ms2_email_manager')));
        $this->modx->mail->address('reply-to',$this->modx->getOption('sender',$options,$this->modx->getOption('emailsender')));
        $this->modx->mail->setHTML($this->modx->getOption('html',$options,true));
        foreach($options['files'] as $file) {
            $this->modx->mail->attach($this->modx->getOption('base_path'). $file);
        }
        $sent = $this->modx->mail->send();
        $this->modx->mail->reset();
        return $sent;
    }

}