<?php

class msGetCostProcessor extends modObjectGetProcessor
{
    public $classKey = 'msDelivery';
    public $languageTopics = array('minishop2:default');
    public $permission = 'msorder_view';
    /** @var  miniShop2 $ms2 */
    protected $ms2;
    public $primaryKeyField = 'delivery_id';
    public $cost = 0;

    /**
     * @return bool|null|string
     */
    public function initialize()
    {
        $this->ms2 = $this->modx->getService('miniShop2');
        if (!$this->modx->hasPermission($this->permission)) {
            return $this->modx->lexicon('access_denied');
        }

        return parent::initialize();
    }

    /**
     * @return array|string
     */
    public function cleanup()
    {

        $delivery = $this->object->toArray();
        $output = [
            'delivery_cost' => $delivery['price'],
        ];

        // Получаем заказ
        if($order = $this->modx->getObject('msOrder', $this->getProperty('order_id'))) {

            // Получаем статус заказа
            if($status = $this->modx->getObject('msOrderStatus', $order->get('status'))) {
                // Если статус итоговый, то возвращаем ошибку
                if($status->get('final')) {
                    return $this->failure($this->modx->lexicon('msorderfields_order_err_delivery'), [
                        'delivery' => $order->get('delivery'),
                        'payment' => $order->get('payment'),
                    ]);
                }
            }

            if($delivery['price'] > 0) {
                if($order->get('cart_cost') > $delivery['free_delivery_amount']) {
                    $output['delivery_cost'] = 0;
                } else {
                    $output['cost'] = $order->get('cart_cost') - $order->get('discount') + $delivery['price'];
                }
            } else {
                $output['cost'] = $order->get('cart_cost') - $order->get('discount');
            }

            // Сохраняем цену заказа
            $order->set('delivery_cost', $output['delivery_cost']);
            $order->set('cost', $output['cost']);
            $order->save();

        }

        return $this->success('', $output);
    }
}

return 'msGetCostProcessor';