<?php

class OrderFieldsCreateProcessor extends modObjectCreateProcessor
{
    public $msorderfields;
    public $classKey = 'OrderFields';
    public $languageTopics = ['msorderfields:default'];

    public function initialize()
    {
        $this->msorderfields = $this->modx->getService('msorderfields', 'msOrderFields', MODX_CORE_PATH . 'components/msorderfields/model/');
        return parent::initialize();
    }


    /**
     * @return bool
     */
    public function beforeSet()
    {
        $name = trim($this->getProperty('name'));
        if (empty($name)) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_fields_err_name'));
        } elseif ($this->modx->getCount($this->classKey, ['name' => $name])) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_fields_err_ae'));
        }

        return parent::beforeSet();
    }

    public function beforeSave()
    {
        $this->object->fromArray(array(
            'rank' => $this->modx->getCount($this->classKey),
        ));

        return parent::beforeSave();
    }

    public function afterSave()
    {
        $name = trim($this->getProperty('name'));
        $fieldmeta = $this->msorderfields->fieldmeta[trim($this->getProperty('xtype'))];
        $type = $fieldmeta['dbtype'] . ($fieldmeta['precision'] ? "({$fieldmeta['precision']})" : '');
        $null = $fieldmeta['null'] ? 'NULL' : 'NOT NULL';
        $default = $fieldmeta['default'] !== null ? " DEFAULT {$fieldmeta['default']}" : '';

        $table = $this->modx->getTableName('msOrderAddress');
        $sql = "ALTER TABLE {$table} ADD `{$name}` {$type} {$null}{$default};";
        $this->modx->exec($sql);

        // Обновляем лексиконы
        $this->msorderfields->ms2Lexicon($this->object->toArray());

        return parent::afterSave();
    }

}

return 'OrderFieldsCreateProcessor';