<?php

class OrderFieldsGetListProcessor extends modObjectGetListProcessor
{
    public $classKey = 'OrderFields';
    public $defaultSortField = 'id';
    public $defaultSortDirection = 'asc';
    public $languageTopics = ['minishop2:manager'];


    /**
     * We do a special check of permissions
     * because our objects is not an instances of modAccessibleObject
     *
     * @return boolean|string
     */
    public function beforeQuery()
    {
        if (!$this->checkPermissions()) {
            return $this->modx->lexicon('access_denied');
        }

        return true;
    }


    /**
     * @param xPDOQuery $c
     *
     * @return xPDOQuery
     */
    public function prepareQueryBeforeCount(xPDOQuery $c)
    {
        $group = $this->getProperty('group');
        if($group) {
            $c->where([
                'group' => $group,
            ]);
        }

        $query = trim($this->getProperty('query'));
        if ($query) {
            $c->where([
                'name:LIKE' => "%{$query}%",
                'OR:lexicon:LIKE' => "%{$query}%",
                'OR:lexicon_frontend:LIKE' => "%{$query}%",
            ]);
        }

        return $c;
    }


    /**
     * @param xPDOObject $object
     *
     * @return array
     */
    public function prepareRow(xPDOObject $object)
    {
        $array = $object->toArray();
        $array['actions'] = [];

        // Edit
        $array['actions'][] = [
            'cls' => '',
            'icon' => 'icon icon-edit',
            'title' => $this->modx->lexicon('msorderfields_update'),
            'action' => 'updateField',
            'button' => true,
            'menu' => true,
        ];

        if (!$array['active']) {
            $array['actions'][] = [
                'cls' => '',
                'icon' => 'icon icon-power-off action-green',
                'title' => $this->modx->lexicon('msorderfields_enable'),
                'action' => 'enableField',
                'button' => true,
                'menu' => true,
            ];
        } else {
            $array['actions'][] = [
                'cls' => '',
                'icon' => 'icon icon-power-off action-gray',
                'title' => $this->modx->lexicon('msorderfields_disable'),
                'action' => 'disableField',
                'button' => true,
                'menu' => true,
            ];
        }

        if($array['editable']) {
            // Remove
            $array['actions'][] = [
                'cls' => '',
                'icon' => 'icon icon-trash-o action-red',
                'title' => $this->modx->lexicon('msorderfields_remove'),
                'action' => 'removeField',
                'button' => true,
                'menu' => true,
            ];
        }

        return $array;
    }

}

return 'OrderFieldsGetListProcessor';