<?php

class OrderFieldsMultipleProcessor extends modProcessor
{

    /**
     * @return array|string
     */
    public function process()
    {
        if (!$method = $this->getProperty('method', false)) {
            return $this->failure();
        }
        $ids = json_decode($this->getProperty('ids'), true);
        if (empty($ids)) {
            return $this->success();
        }

        /** @var msorderfields $msorderfields */
        $msorderfields = $this->modx->getService('msorderfields', 'msOrderFields', MODX_CORE_PATH . 'components/msorderfields/model/');

        foreach ($ids as $id) {
            /** @var modProcessorResponse $response */
            $response = $msorderfields->runProcessor('mgr/fields/' . $method, array('id' => $id));
            if ($response->isError()) {
                return $response->getResponse();
            }
        }

        return $this->success();
    }

}

return 'OrderFieldsMultipleProcessor';