<?php

class OrderFieldsRemoveProcessor extends modObjectRemoveProcessor
{
    public $objectType = 'msorderfields';
    public $msorderfields;
    public $classKey = 'OrderFields';
    public $languageTopics = ['msorderfields'];
    //public $permission = 'remove';


    /**
     * @return array|string
     */
    public function initialize()
    {
        if (!$this->checkPermissions()) {
            return $this->failure($this->modx->lexicon('access_denied'));
        }
        $this->msorderfields = $this->modx->getService('msorderfields', 'msOrderFields', MODX_CORE_PATH . 'components/msorderfields/model/');
        return parent::initialize();
    }
    
    /**
     * @return bool|string
     */
    public function beforeRemove()
    {
        $field = $this->object->name;
        $table = $this->modx->getTableName('msOrderAddress');
        $sql = 'ALTER TABLE ' . $table . ' DROP COLUMN `'.$field.'`';
        $this->modx->exec($sql);

        // Удаляем лексиконы
        $this->msorderfields->ms2Lexicon($this->object->toArray(),false);

        return parent::beforeRemove();
    }

}

return 'OrderFieldsRemoveProcessor';