<?php

class OrderFieldsUpdateProcessor extends modObjectUpdateProcessor
{
    public $msorderfields;
    public $object;
    public $classKey = 'OrderFields';
    public $languageTopics = ['msorderfields'];
    //public $permission = 'save';


    /**
     * @return bool|null|string
     */
    public function initialize()
    {
        if (!$this->checkPermissions()) {
            return $this->modx->lexicon('access_denied');
        }
        $this->msorderfields = $this->modx->getService('msorderfields', 'msOrderFields', MODX_CORE_PATH . 'components/msorderfields/model/');
        return parent::initialize();
    }


    /**
     * @return bool
     */
    public function beforeSet()
    {
        $id = (int)$this->getProperty('id');
        $name = trim($this->getProperty('name'));
        if (empty($id)) {
            return $this->modx->lexicon('msorderfields_fields_err_ns');
        }

        if (empty($name)) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_fields_err_name'));
        } elseif ($this->modx->getCount($this->classKey, ['name' => $name, 'id:!=' => $id])) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_fields_err_ae'));
        }

        return parent::beforeSet();
    }

    public function beforeSave()
    {
        // Проверяем совпадают ли имена поля
        $newName = trim($this->getProperty('name'));
        if($field = $this->modx->getObject($this->classKey, (int)$this->getProperty('id'))) {
            if($field->get('name') != $newName) {
                $fieldmeta = $this->msorderfields->fieldmeta[trim($this->getProperty('xtype'))];
                $type = $fieldmeta['dbtype'] . ($fieldmeta['precision'] ? "({$fieldmeta['precision']})" : '');

                $table = $this->modx->getTableName('msOrderAddress');
                $sql = "ALTER TABLE {$table} CHANGE {$field->get('name')} {$newName} {$type};";
                $this->modx->exec($sql);
            }
        }

        return parent::beforeSave();
    }

    /**
     * Override in your derivative class to do functionality after save() is run
     * @return boolean
     */
    public function afterSave()
    {

        // Обновляем поле
        $name = $this->object->get('name');
        $fieldmeta = $this->msorderfields->fieldmeta[trim($this->getProperty('xtype'))];
        $type = $fieldmeta['dbtype'] . ($fieldmeta['precision'] ? "({$fieldmeta['precision']})" : '');
        $null = $fieldmeta['null'] ? 'NULL' : 'NOT NULL';
        $default = $fieldmeta['default'] !== null ? " DEFAULT {$fieldmeta['default']}" : '';

        $table = $this->modx->getTableName('msOrderAddress');
        $sql = "ALTER TABLE {$table} MODIFY COLUMN `{$name}` {$type} {$null}{$default};";
        $this->modx->exec($sql);

        // Обновляем лексиконы
        $this->msorderfields->ms2Lexicon($this->object->toArray());

        return parent::afterSave();
    }
}

return 'OrderFieldsUpdateProcessor';
