<?php

class OrderGroupsCreateProcessor extends modObjectCreateProcessor
{
    public $msorderfields;
    public $classKey = 'OrderGroups';
    public $languageTopics = ['msorderfields:default'];

    public function initialize()
    {
        $this->msorderfields = $this->modx->getService('msorderfields', 'msOrderFields', MODX_CORE_PATH . 'components/msorderfields/model/');
        return parent::initialize();
    }


    /**
     * @return bool
     */
    public function beforeSet()
    {
        $name = trim($this->getProperty('name'));
        if (empty($name)) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_groups_err_name'));
        } elseif ($this->modx->getCount($this->classKey, ['name' => $name])) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_groups_err_ae'));
        }

        return parent::beforeSet();
    }

    public function beforeSave()
    {
        $this->object->fromArray(array(
            'rank' => $this->modx->getCount($this->classKey),
        ));

        return parent::beforeSave();
    }

}

return 'OrderGroupsCreateProcessor';