<?php

class OrderGroupsGetListProcessor extends modObjectGetListProcessor
{
    public $classKey = 'OrderGroups';
    public $defaultSortField = 'id';
    public $defaultSortDirection = 'asc';
    public $languageTopics = ['minishop2:manager'];


    /**
     * We do a special check of permissions
     * because our objects is not an instances of modAccessibleObject
     *
     * @return boolean|string
     */
    public function beforeQuery()
    {
        if (!$this->checkPermissions()) {
            return $this->modx->lexicon('access_denied');
        }

        return true;
    }


    /**
     * @param xPDOQuery $c
     *
     * @return xPDOQuery
     */
    public function prepareQueryBeforeCount(xPDOQuery $c)
    {
        $query = trim($this->getProperty('query'));
        if ($query) {
            $c->where([
                'name:LIKE' => "%{$query}%",
            ]);
        }

        if ($this->getProperty('combo')) {
            $c->select('id,name');
            $c->where([
                'active' => 1,
                'fields' => 1,
            ]);
        }


        return $c;
    }


    /**
     * @param xPDOObject $object
     *
     * @return array
     */
    public function prepareRow(xPDOObject $object)
    {

        if ($this->getProperty('combo')) {
            return array(
                'id' => $object->get('id'),
                'name' => $object->get('name'),
            );
        }

        $array = $object->toArray();
        $array['actions'] = [];

        // Edit
        $array['actions'][] = [
            'cls' => '',
            'icon' => 'icon icon-edit',
            'title' => $this->modx->lexicon('msorderfields_update'),
            'action' => 'updateGroup',
            'button' => true,
            'menu' => true,
        ];


        if (!$array['active']) {
            $array['actions'][] = [
                'cls' => '',
                'icon' => 'icon icon-power-off action-green',
                'title' => $this->modx->lexicon('msorderfields_enable'),
                'action' => 'enableGroup',
                'button' => true,
                'menu' => true,
            ];
        } else {
            $array['actions'][] = [
                'cls' => '',
                'icon' => 'icon icon-power-off action-gray',
                'title' => $this->modx->lexicon('msorderfields_disable'),
                'action' => 'disableGroup',
                'button' => true,
                'menu' => true,
            ];
        }

        if ($array['fields']) {
            $array['actions'][] = [
                'cls' => '',
                'icon' => 'icon icon-eye',
                'title' => $this->modx->lexicon('msorderfields_groups_view'),
                'action' => 'viewGroup',
                'button' => true,
                'menu' => true,
            ];
        }

        if($array['editable']) {
            // Remove
            $array['actions'][] = [
                'cls' => '',
                'icon' => 'icon icon-trash-o action-red',
                'title' => $this->modx->lexicon('msorderfields_remove'),
                'action' => 'removeGroup',
                'button' => true,
                'menu' => true,
            ];
        }

        return $array;
    }

}

return 'OrderGroupsGetListProcessor';