<?php

class OrderGroupsUpdateProcessor extends modObjectUpdateProcessor
{
    public $msorderfields;
    public $object;
    public $classKey = 'OrderGroups';
    public $languageTopics = ['msorderfields'];
    //public $permission = 'save';


    /**
     * @return bool|null|string
     */
    public function initialize()
    {
        if (!$this->checkPermissions()) {
            return $this->modx->lexicon('access_denied');
        }
        $this->msorderfields = $this->modx->getService('msorderfields', 'msOrderFields', MODX_CORE_PATH . 'components/msorderfields/model/');
        return parent::initialize();
    }


    /**
     * @return bool
     */
    public function beforeSet()
    {
        $id = (int)$this->getProperty('id');
        $name = trim($this->getProperty('name'));
        if (empty($id)) {
            return $this->modx->lexicon('msorderfields_fields_err_ns');
        }

        if (empty($name)) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_groups_err_name'));
        } elseif ($this->modx->getCount($this->classKey, ['name' => $name, 'id:!=' => $id])) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_groups_err_ae'));
        }

        return parent::beforeSet();
    }

    /**
     * Override in your derivative class to do functionality after save() is run
     * @return boolean
     */
    public function afterSave()
    {
        // Обновляем лексиконы
        $properties = $this->object->toArray();
        $lang = $this->modx->getOption('manager_language', '', 'ru');
        if(!$properties['editable'] && !empty($properties['lexicon'])) {
            $where = [
                'namespace' => 'minishop2',
                'topic' => $properties['lexicon'] == 'ms2_order' ? 'default' : 'manager',
                'language' => $lang,
                'name' => $properties['lexicon'],
            ];
            if(!$lexicon = $this->modx->getObject('modLexiconEntry', $where)) {
                $lexicon = $this->modx->newObject('modLexiconEntry', $where);
            }
            $lexicon->set('value', $properties['name']);
            $lexicon->save();
        }

        return parent::afterSave();
    }
}

return 'OrderGroupsUpdateProcessor';
