<?php

class msOrderFieldsItemCreateProcessor extends modObjectCreateProcessor
{
    public $objectType = 'msOrderFieldsItem';
    public $classKey = 'msOrderFieldsItem';
    public $languageTopics = ['msorderfields'];
    //public $permission = 'create';


    /**
     * @return bool
     */
    public function beforeSet()
    {
        $name = trim($this->getProperty('name'));
        if (empty($name)) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_item_err_name'));
        } elseif ($this->modx->getCount($this->classKey, ['name' => $name])) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_item_err_ae'));
        }

        return parent::beforeSet();
    }

}

return 'msOrderFieldsItemCreateProcessor';