<?php

class msOrderFieldsItemUpdateProcessor extends modObjectUpdateProcessor
{
    public $objectType = 'msOrderFieldsItem';
    public $classKey = 'msOrderFieldsItem';
    public $languageTopics = ['msorderfields'];
    //public $permission = 'save';


    /**
     * @return bool|null|string
     */
    public function initialize()
    {
        if (!$this->checkPermissions()) {
            return $this->modx->lexicon('access_denied');
        }

        return parent::initialize();
    }


    /**
     * @return bool
     */
    public function beforeSet()
    {
        $id = (int)$this->getProperty('id');
        $name = trim($this->getProperty('name'));
        if (empty($id)) {
            return $this->modx->lexicon('msorderfields_item_err_ns');
        }

        if (empty($name)) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_item_err_name'));
        } elseif ($this->modx->getCount($this->classKey, ['name' => $name, 'id:!=' => $id])) {
            $this->modx->error->addField('name', $this->modx->lexicon('msorderfields_item_err_ae'));
        }

        return parent::beforeSet();
    }
}

return 'msOrderFieldsItemUpdateProcessor';
