<?php

class msOrderGetCostProcessor extends modObjectGetProcessor
{
    public $classKey = 'msOrder';
    public $languageTopics = array('minishop2:default');
    public $permission = 'msorder_view';
    /** @var miniShop2 $ms2 */
    protected $ms2;
    public $primaryKeyField = 'id';
    public $cost = 0;

    /**
     * @return bool|null|string
     */
    public function initialize()
    {
        $this->ms2 = $this->modx->getService('miniShop2');
        if (!$this->modx->hasPermission($this->permission)) {
            return $this->modx->lexicon('access_denied');
        }

        return parent::initialize();
    }

    /**
     * @return array|string
     */
    public function cleanup()
    {

        $order = $this->object->toArray();
        $output = [
            'delivery_cost' => $order['delivery_cost'],
            'cart_cost' => $order['cart_cost'],
        ];

        if($this->getProperty('delivery_cost') < 0) {
            return $this->failure('', $output);
        }

        // Получаем доставку
        if($delivery = $this->modx->getObject('msDelivery', $order['delivery'])) {

            // Получаем статус заказа
            if($status = $this->modx->getObject('msOrderStatus', $order['status'])) {
                // Если статус итоговый, то возвращаем ошибку
                if($status->get('final')) {
                    $output['final'] = 1;
                    return $this->failure('', $output);
                }
            }

            // Иначе меняем цену заказа
            $output = [
                'delivery_cost' => $this->getProperty('delivery_cost'),
                'cart_cost' => $order['cart_cost'],
                'cost' => $order['cart_cost'] - $this->getProperty('discount') + $this->getProperty('delivery_cost'),
            ];
        }

        $this->object->set('cost', $output['cost']);
        if($this->object->save()) {
            return $this->success('', $output);
        };

        return $this->failure('', [
            'delivery_cost' => $order['delivery_cost'],
            'cart_cost' => $order['cart_cost'],
        ]);
    }
}

return 'msOrderGetCostProcessor';