<?php

class msOrderProductGetPriceProcessor extends modObjectGetProcessor
{
    public $classKey = 'msProduct';
    public $languageTopics = array('minishop2:default');
    public $permission = 'msorder_view';
    public $primaryKeyField = 'product_id';

    /** @var miniShop2 $ms2 */
    protected $ms2;

    /** @var msPaidOptions $mspaidoptions */
    protected $mspaidoptions;

    /** @var msOptionsPrice2 $msoptionsprice */
    protected $msoptionsprice;

    /**
     * @return bool|null|string
     */
    public function initialize()
    {
        if (!$this->modx->hasPermission($this->permission)) {
            return $this->modx->lexicon('access_denied');
        }

        // miniShop2
        $this->ms2 = $this->modx->getService('miniShop2');

        // msPaidOptions
        $this->mspaidoptions = $this->modx->getService('msPaidOptions');

        // msOptionsPrice2
        $this->msoptionsprice = $this->modx->getService('msoptionsprice');

        return parent::initialize();
    }

    /**
     * @return array|string
     */
    public function cleanup()
    {

        $order = $this->object->toArray();
        $options = json_decode($this->properties['options'],1);

        // Получаем оригинальную цену
        $output = [
            'price' => $order['price'],
        ];

        // Получаем цену msOptionsPrice2
        if($this->msoptionsprice && $price = $this->getMsOptionsPrice2($options)) {
            $this->object->set('price', $price);
        }

        // получаем цену с учетом платных опций (msPaidOptions)
        if($this->mspaidoptions) {
            $output['price'] = $this->mspaidoptions->getPrice($this->object, $options);
        }

        return $this->success('', $output);
    }

    public function getMsOptionsPrice2($options)
    {
        foreach($options as $option => $value) {
            if(empty($value)) continue;
            if(is_array($value)) continue;
            if($mods = $this->modx->getCollection('msopModificationOption', [
                'rid' => 84,
                'key' => $option,
                'value' => $value
            ])) {
                foreach($mods as $mod) {
                    // Получаем другие опции
                    $modsoptions = $this->modx->getCollection('msopModificationOption', [
                        'mid' => $mod->get('mid')
                    ]);
                    // Проверяем совпадают ли опции
                    foreach($modsoptions as $item) {
                        if($item->get('value') != $options[$item->get('key')]) {
                            continue 2;
                        }
                    }
                    // Получаем цену модификации
                    if($modPrice = $this->modx->getObject('msopModification', ['id' => $mod->get('mid'), 'active' => 1])) {
                        return $modPrice->get('price');
                    }
                }
            }
        }

        return false;
    }
}

return 'msOrderProductGetPriceProcessor';