msOrderFields.combo.Search = function (config) {
    config = config || {};
    Ext.applyIf(config, {
        xtype: 'twintrigger',
        ctCls: 'x-field-search',
        allowBlank: true,
        msgTarget: 'under',
        emptyText: _('search'),
        name: 'query',
        triggerAction: 'all',
        clearBtnCls: 'x-field-search-clear',
        searchBtnCls: 'x-field-search-go',
        onTrigger1Click: this._triggerSearch,
        onTrigger2Click: this._triggerClear,
    });
    msOrderFields.combo.Search.superclass.constructor.call(this, config);
    this.on('render', function () {
        this.getEl().addKeyListener(Ext.EventObject.ENTER, function () {
            this._triggerSearch();
        }, this);
    });
    this.addEvents('clear', 'search');
};
Ext.extend(msOrderFields.combo.Search, Ext.form.TwinTriggerField, {

    initComponent: function () {
        Ext.form.TwinTriggerField.superclass.initComponent.call(this);
        this.triggerConfig = {
            tag: 'span',
            cls: 'x-field-search-btns',
            cn: [
                {tag: 'div', cls: 'x-form-trigger ' + this.searchBtnCls},
                {tag: 'div', cls: 'x-form-trigger ' + this.clearBtnCls}
            ]
        };
    },

    _triggerSearch: function () {
        this.fireEvent('search', this);
    },

    _triggerClear: function () {
        this.fireEvent('clear', this);
    },

});
Ext.reg('msorderfields-combo-search', msOrderFields.combo.Search);
Ext.reg('msorderfields-field-search', msOrderFields.combo.Search);

msOrderFields.combo.Types = function(config) {
    config = config || {};
    Ext.applyIf(config,{
        store: new Ext.data.ArrayStore({
            id: 0,
            fields: ['display','value'],
            data: [
                ['Text','textfield'],
                ['Textarea','textarea'],
                ['Richtext','richtext'],
                ['Number','numberfield'],
                ['Checkbox','xcheckbox'],
                ['Boolean','msorderfields-combo-boolean'],
                ['Date','datefield'],
                ['Time','timefield'],
                ['DateTime','minishop2-xdatetime'],
                ['Display','displayfield'],
                ['Chunk','minishop2-combo-chunk'],
                ['File','minishop2-combo-browser'],
            ]
        }),
        mode: 'local',
        displayField: 'display',
        valueField: 'value',
    });
    msOrderFields.combo.Types.superclass.constructor.call(this,config);
};
Ext.extend(msOrderFields.combo.Types,MODx.combo.ComboBox);
Ext.reg('msorderfields-combo-types',msOrderFields.combo.Types);

msOrderFields.combo.TypesOrder = function(config) {
    config = config || {};
    Ext.applyIf(config,{
        store: new Ext.data.ArrayStore({
            id: 0,
            fields: ['display','value'],
            data: [
                ['Text','textfield'],
                ['Richtext','richtext'],
                ['Number','numberfield'],
                ['Display','displayfield'],
            ]
        }),
        mode: 'local',
        displayField: 'display',
        valueField: 'value',
    });
    msOrderFields.combo.TypesOrder.superclass.constructor.call(this,config);
};
Ext.extend(msOrderFields.combo.TypesOrder,MODx.combo.ComboBox);
Ext.reg('msorderfields-combo-types-order',msOrderFields.combo.TypesOrder);

msOrderFields.combo.Groups = function (config) {
    config = config || {};
    Ext.applyIf(config, {
        url: msOrderFields.config.connector_url,
        baseParams: {
            action: 'mgr/groups/getlist',
            sort: 'rank',
            sortdir: 'asc',
            combo: 1,
        },
        fields: ['name', 'id'],
        mode: 'remote',
        displayField: 'name',
        valueField: 'id',
        hiddenName: 'group',
        autoLoad: false
    });
    msOrderFields.combo.Groups.superclass.constructor.call(this, config);
};
Ext.extend(msOrderFields.combo.Groups, MODx.combo.ComboBox);
Ext.reg('msorderfields-combo-groups', msOrderFields.combo.Groups);