const showLog = localStorage.getItem('showLog');

if (MODx.loadRTE && TinyMCERTE) {
    TinyMCERTE.editorConfig = {
        language: MODx.config['manager_language'],
        enable_link_list: MODx.config['tinymcerte.enable_link_list'],
        plugins: MODx.config['tinymcerte.plugins'],
        image_advtab: MODx.config['tinymcerte.image_advtab'],
        relative_urls: MODx.config['tinymcerte.relative_urls'],
        remove_script_host: MODx.config['tinymcerte.remove_script_host'],
        skin: MODx.config['tinymcerte.skin'],
        statusbar: MODx.config['tinymcerte.statusbar'],
        menubar: MODx.config['tinymcerte.menubar'],
        toolbar1: MODx.config['tinymcerte.toolbar1'],
    };
}

msOrderFields.combo.Boolean = function(config) {
    config = config || {};

    Ext.applyIf(config,{
        store: new Ext.data.ArrayStore({
            id: 0,
            fields: ['display','value'],
            data: MODx.config.manager_language == 'ru' ? [['Да',1], ['Нет',0]] : [['Yes',1], ['No',0]]
        }),
        mode: 'local',
        displayField: 'display',
        valueField: 'value',
    });
    msOrderFields.combo.Boolean.superclass.constructor.call(this,config);
};
Ext.extend(msOrderFields.combo.Boolean,MODx.combo.ComboBox);
Ext.reg('msorderfields-combo-boolean',msOrderFields.combo.Boolean);

Ext.override(miniShop2.window.UpdateOrder, {

    getTabs: function (config) {

        var msgroups = msOrderFields.groups;
        if(showLog) console.log('[getTabs]', msgroups);

        var tabs = [];
        var self = this;

        msgroups.forEach(function(group){

            var items = [];
            if(group['description']) {
                items.push({
                    html: group['description'],
                    cls: 'panel-desc',
                })
            }

            switch(group['lexicon']) {
                case 'ms2_order':
                    items.push(self.getOrderFields(config));
                    tabs.push({
                        title: _('ms2_order'),
                        hideMode: 'offsets',
                        defaults: {msgTarget: 'under', border: false},
                        items: items,
                    });
                    break;
                case 'ms2_order_products':
                    items.push({
                        xtype: 'minishop2-grid-order-products',
                        order_id: config.record.id
                    });
                    tabs.push({
                        title: _('ms2_order_products'),
                        items: items
                    });
                    break;
                case 'ms2_address':
                    var address = self.getCustomFields(config,group['id']);
                    if (address.length > 0) {
                        items.push(address);
                        tabs.push({
                            layout: 'form',
                            title: _('ms2_address'),
                            hideMode: 'offsets',
                            bodyStyle: 'padding:5px 0;',
                            defaults: {msgTarget: 'under', border: false},
                            items: items
                        });
                    }
                    break;
                case 'ms2_order_log':
                    items.push({
                        xtype: 'minishop2-grid-order-logs',
                        order_id: config.record.id
                    });
                    tabs.push({
                        title: _('ms2_order_log'),
                        items: items
                    });
                    break;

                default:
                    var fields = self.getCustomFields(config,group['id']);
                    if (fields.length > 0) {
                        items.push(fields);
                        tabs.push({
                            layout: 'form',
                            title: group['name'],
                            hideMode: 'offsets',
                            bodyStyle: 'padding:5px 0;',
                            defaults: {msgTarget: 'under', border: false},
                            items: items
                        });
                    }
            }

        });

        return tabs;
    },

    getOrderFields: function (config) {

        var fields = [{
            xtype: 'hidden',
            name: 'id'
        }, {
            layout: 'column',
            defaults: {msgTarget: 'under', border: false},
            style: 'padding:15px 5px;text-align:center;',
            items: [{
                columnWidth: .33,
                layout: 'form',
                items: [{
                    xtype: 'minishop2-combo-user',
                    name: 'user_id',
                    fieldLabel: _('ms2_user'),
                    anchor: '95%',
                }]
            }, {
                columnWidth: .33,
                layout: 'form',
                items: [{
                    xtype: 'displayfield',
                    name: 'cart_cost',
                    fieldLabel: _('ms2_cart_cost'),
                    anchor: '100%',
                    style: 'font-size:1.1em;'
                }]
            }, {
                columnWidth: .33,
                layout: 'form',
                items: [{
                    xtype: 'displayfield',
                    name: 'cost',
                    fieldLabel: _('ms2_order_cost'),
                    anchor: '100%',
                    style: 'font-size:1.1em;'
                }]
            }]
        }];


        if(typeof msPromoCode2 == 'object') {
            fields.push({
                xtype: 'mspc2-order-fieldset',
                id: config.id + '-mspc2',
                order: config.record.id,
            });
        }

        var fieldset = [{
            columnWidth: .33,
            layout: 'form',
            items: [
                {xtype: 'displayfield', name: 'num', fieldLabel: _('ms2_num'), anchor: '100%'},
                {
                    xtype: (+MODx.config.msorderfields_discount ? 'numberfield' : 'hidden'),
                    name: 'discount',
                    id: 'minishop2-discount',
                    fieldLabel: _('ms2_discount'),
                    anchor: '100%',
                    minValue:0,
                    listeners: {
                        render: {
                            scope: this,
                            fn: function(discount) {
                                this.changeDiscount(config,discount);
                            },
                        },
                        change: {
                            scope: this,
                            fn: function(discount) {
                                this.changeDiscount(config,discount);
                            },
                        },
                    },
                }
            ]
        }, {
            columnWidth: .33,
            layout: 'form',
            items: [
                {xtype: 'displayfield', name: 'createdon', fieldLabel: _('ms2_createdon'), anchor: '100%'},
                {
                    xtype: (+MODx.config.msorderfields_delivery_cost ? 'numberfield' : 'displayfield'),
                    name: 'delivery_cost', fieldLabel: _('ms2_delivery_cost'), anchor: '100%',
                    id: 'minishop2-delivery-cost',
                    minValue:0,
                    listeners: {
                        render: {
                            scope: this,
                            fn: function(delivery_cost) {
                                this.changeDelivery(config,delivery_cost);
                            },
                        },
                        change: {
                            scope: this,
                            fn: function(delivery_cost) {
                                this.changeDelivery(config,delivery_cost);
                            },
                        },
                    },
                }
            ]
        }, {
            columnWidth: .33,
            layout: 'form',
            items: [
                {xtype: 'displayfield', name: 'updatedon', fieldLabel: _('ms2_updatedon'), anchor: '100%'},
                {
                    xtype: (+MODx.config.msorderfields_weight ? 'numberfield' : 'displayfield'),
                    name: 'weight',
                    minValue:0,
                    fieldLabel: _('ms2_weight'),
                    anchor: '100%',
                    listeners: {
                        change: function(weight) {
                            if(weight.getValue() < 0) {
                                weight.setValue(0);
                            }
                        }
                    }
                }
            ]
        }];


        fields.push({
            xtype: 'fieldset',
            layout: 'column',
            style: 'padding:15px 5px;text-align:center;',
            defaults: {msgTarget: 'under', border: false},
            items: fieldset
        });


        fields.push({
            layout: 'column',
            defaults: {msgTarget: 'under', border: false},
            anchor: '100%',
            items: [{
                columnWidth: .48,
                layout: 'form',
                items: [{
                    xtype: 'minishop2-combo-status',
                    name: 'status',
                    fieldLabel: _('ms2_status'),
                    anchor: '100%',
                    order_id: config.record.id
                }, {
                    xtype: 'minishop2-combo-delivery',
                    name: 'delivery',
                    fieldLabel: _('ms2_delivery'),
                    anchor: '100%',
                    listeners: {
                        select: function (combo, row) {

                            var payments = Ext.getCmp('minishop2-combo-payment');
                            var store = payments.getStore();
                            payments.setValue('');
                            store.baseParams.delivery_id = row.id;
                            store.load();

                            MODx.Ajax.request({
                                url: msOrderFields.config.url,
                                params: {
                                    action: 'mgr/delivery/getcost',
                                    delivery_id: row.id,
                                    order_id: config.record.addr_id,
                                },
                                listeners: {
                                    success: {
                                        fn: function (response) {
                                            var w = Ext.getCmp('minishop2-window-order-update');
                                            w.setValues(response.object);
                                        },
                                        scope: this
                                    },
                                    failure: {
                                        fn: function (response) {
                                            MODx.msg.alert(_('error'), response.message);
                                            var w = Ext.getCmp('minishop2-window-order-update');
                                            if(response.object) {
                                                w.setValues(response.object);
                                            }
                                        },
                                        scope: this
                                    }
                                }
                            });
                        }
                    }
                }, {
                    xtype: 'minishop2-combo-payment',
                    name: 'payment',
                    fieldLabel: _('ms2_payment'),
                    anchor: '100%',
                    delivery_id: config.record.delivery
                }]
            }, {
                columnWidth: .5,
                layout: 'form',
                items: [
                    {xtype: 'textarea', name: 'comment', fieldLabel: _('ms2_comment'), anchor: '100%', height: 170}
                ]
            }]
        });

        return fields;
    },

    getCustomFields: function (config,group) {
        var msfields = msOrderFields.fields.filter(function(field){
            return field['group'] == group;
        });
        if(showLog) console.log('[getAddressFields]:group ' + group, msfields);

        var all = {};
        msfields.forEach(function(field){

            all[field['name']] = {
                columnWidth: field['size'] / 100,
                id: config.id + '-' + field['name'],
                xtype: field['xtype'],
                allowBlank: !+field['required']
            };

            switch(field['xtype']) {
                case 'datefield':
                    all[field['name']].format = MODx.config.manager_date_format;
                    break;
                case 'timefield':
                    all[field['name']].format = MODx.config.manager_time_format;
                    // all[field['name']].increment = 30;
                    break;
                case 'xcheckbox':
                    all[field['name']].hideLabel = true;
                    all[field['name']].boxLabel = _('ms2_' + field['name']);
                    all[field['name']].checked = field['name'].value ? 1 : 0;
                    break;
                case 'msorderfields-combo-boolean':
                    all[field['name']].hiddenName = 'addr_' + field['name'];
                    break;
                case 'displayfield':
                    all[field['name']].style = 'min-height:20px;line-height: 20px;padding:5px;border:1px solid #efefef;width:95%;background-color:#fbfbfb;'
                    break;
                case 'richtext':
                    all[field['name']].xtype = 'textarea';
                    all[field['name']].listeners = {
                        render: function (el) {
                            if (MODx.loadRTE) {
                                window.setTimeout(function() {
                                    MODx.loadRTE(el.id);
                                }, 300);
                            }
                        }
                    };
                    break;
            }

        })

        var fields = [], tmp = [];
        for (var i = 0; i < msfields.length; i++) {
            var field = msfields[i]['name'];
            if (all[field]) {
                Ext.applyIf(all[field], {
                    xtype: 'textfield',
                    name: 'addr_' + field,
                    fieldLabel: _('ms2_' + field),
                });
                all[field].anchor = '99%';
                tmp.push(all[field]);
            }
        }

        var addx = function (w1, w2) {
            if (!w1) {
                w1 = .5;
            }
            if (!w2) {
                w2 = .5;
            }
            return {
                layout: 'column',
                defaults: {msgTarget: 'under', border: false},
                items: [
                    {columnWidth: +w1.toFixed(1), layout: 'form', items: []},
                    {columnWidth: +w2.toFixed(1), layout: 'form', items: []}
                ]
            };
        };

        var column = 0;
        var index = 0;
        var idx = -1;
        if (tmp.length > 0) {
            for (i = 0; i < tmp.length; i++) {

                if(tmp[i]['columnWidth'] == 1) {
                    column = 0;
                    index = 0;
                    idx++;

                    tmp[i].anchor = '99.5%';
                    tmp[i].msgTarget = 'under';
                    fields.push(tmp[i]);
                } else {
                    if (!column) {
                        fields.push(addx(tmp[i]['columnWidth'], 1-tmp[i]['columnWidth']));
                        column = 1;
                        index = 0;
                        idx++;
                    }
                    fields[idx].items[index].items.push(tmp[i]);
                    if(++index > 1) {
                        column = 0;
                        index = 0;
                    }
                }
            }
        }
        if(showLog) console.log('[getAddressFields]:fields', fields);
        return fields;
    },

    changeDelivery: function(config,delivery_cost) {
        if(showLog) console.log('[changeDelivery]', config, delivery_cost);
        MODx.Ajax.request({
            url: msOrderFields.config.url,
            params: {
                action: 'mgr/order/getcost',
                id: config.record.id,
                delivery_cost: delivery_cost.value,
                discount: Ext.getCmp('minishop2-discount').getValue(),
            },
            listeners: {
                success: {
                    fn: function (response) {
                        var w = Ext.getCmp('minishop2-window-order-update');
                        w.setValues(response.object);
                    },
                    scope: this
                },
                failure: {
                    fn: function (response) {
                        if(response.message) {
                            MODx.msg.alert(_('error'), response.message);
                        }
                        delivery_cost.setValue(response.object.delivery_cost);
                        if(response.object.final) {
                            delivery_cost.setMinValue(response.object.delivery_cost);
                            delivery_cost.setMaxValue(response.object.delivery_cost);
                        }
                    },
                    scope: this
                }
            }
        });
    },

    changeDiscount: function(config,discount) {
        if(showLog) console.log('[changeDiscount]', config, discount);
        MODx.Ajax.request({
            url: msOrderFields.config.url,
            params: {
                action: 'mgr/discount/getcost',
                id: config.record.id,
                discount: discount.value,
                delivery_cost: Ext.getCmp('minishop2-delivery-cost').getValue(),
            },
            listeners: {
                success: {
                    fn: function (response) {
                        var w = Ext.getCmp('minishop2-window-order-update');
                        w.setValues(response.object);
                    },
                    scope: this
                },
                failure: {
                    fn: function (response) {
                        if(response.message) {
                            MODx.msg.alert(_('error'), response.message);
                        }
                        discount.setValue(response.object.discount);
                        if(response.object.final) {
                            discount.setMinValue(response.object.discount);
                            discount.setMaxValue(response.object.discount);
                        }
                    },
                    scope: this
                }
            }
        });
    },
});

Ext.override(miniShop2.grid.OrderProducts, {

    addOrderProduct: function (combo, row) {
        var id = row.id;
        combo.reset();

        MODx.Ajax.request({
            url: miniShop2.config['connector_url'],
            params: {
                action: 'mgr/product/get',
                id: id
            },
            listeners: {
                success: {
                    fn: function (r) {
                        var w = Ext.getCmp('minishop2-window-orderproduct-update');
                        if (w) {
                            w.close();
                        }

                        r.object.order_id = this.config.order_id;
                        r.object.count = 1;
                        r.object.name = r.object['pagetitle'];
                        w = MODx.load({
                            xtype: 'minishop2-window-orderproduct-update',
                            id: 'minishop2-window-orderproduct-update',
                            record: r.object,
                            action: 'mgr/orders/product/create',
                            listeners: {
                                success: {
                                    fn: function (res) {
                                        if(showLog) console.log('[addOrderProduct]', res);
                                        miniShop2.grid.Orders.changed = true;
                                        this.refresh();
                                        this.updateOrder(r.object.order_id);
                                    }, scope: this
                                }
                            }
                        });
                        w.fp.getForm().reset();
                        w.fp.getForm().setValues(r.object);
                        w.show(Ext.EventObject.target);
                    }, scope: this
                }
            }
        });
    },

    updateOrderProduct: function (btn, e, row) {
        if (typeof(row) != 'undefined') {
            this.menu.record = row.data;
        }
        var id = this.menu.record.id;

        MODx.Ajax.request({
            url: miniShop2.config['connector_url'],
            params: {
                action: 'mgr/orders/product/get',
                id: id
            },
            listeners: {
                success: {
                    fn: function (r) {
                        var w = Ext.getCmp('minishop2-window-orderproduct-update');
                        if (w) {
                            w.close();
                        }

                        r.object.order_id = this.config.order_id;
                        w = MODx.load({
                            xtype: 'minishop2-window-orderproduct-update',
                            id: 'minishop2-window-orderproduct-update',
                            record: r.object,
                            action: 'mgr/orders/product/update',
                            listeners: {
                                success: {
                                    fn: function (res) {
                                        if(showLog) console.log('[updateOrderProduct]', res);
                                        miniShop2.grid.Orders.changed = true;
                                        this.refresh();
                                        this.updateOrder(r.object.order_id);

                                    }, scope: this
                                },
                            }
                        });
                        w.fp.getForm().reset();
                        w.fp.getForm().setValues(r.object);
                        w.show(e.target);
                    }, scope: this
                }
            }
        });
    },

    removeOrderProduct: function () {
        if (!this.menu.record) {
            return;
        }

        MODx.msg.confirm({
            title: _('ms2_menu_remove'),
            text: _('ms2_menu_remove_confirm'),
            url: miniShop2.config['connector_url'],
            params: {
                action: 'mgr/orders/product/remove',
                id: this.menu.record.id
            },
            listeners: {
                success: {
                    fn: function (res) {
                        if(showLog) console.log('[removeOrderProduct]', res);
                        miniShop2.grid.Orders.changed = true;
                        this.refresh();
                        this.updateOrder(this.config.order_id);
                    }, scope: this
                }
            }
        });
    },

    updateOrder: function (order_id) {
        if(Ext.isEmpty(order_id)) return;

        MODx.Ajax.request({
            url: miniShop2.config['connector_url'],
            params: {
                action: 'mgr/orders/get',
                id: order_id
            },
            listeners: {
                success: {
                    fn: function (r) {
                        if(showLog) console.log('[updateOrder]', r.object);
                        if(r.success) {
                            var w = Ext.getCmp('minishop2-window-order-update');
                            w.setValues({
                                'cart_cost': r.object.cart_cost,
                                'cost': r.object.cost - r.object.discount,
                                'weight': r.object.weight,
                            });
                        }
                    }, scope: this
                }
            }
        });
    }
});

Ext.override(miniShop2.window.OrderProduct, {

    getOptionsFields: function (config) {
        if(showLog) console.log('[getOptionsFields]', config);

        var fields = [];
        var all = [];
        if(config.record.options || miniShop2.config['order_product_options_fields']) {

            var options = {};
            if(config.record.options) {
                options = JSON.parse(config.record.options);
            } else {
                miniShop2.config['order_product_options_fields'].forEach(function (key){
                    options[key] = '';
                })
            }

            if(showLog) console.log('[options]', options);

            for(let key in options) {
                if(miniShop2.config['order_product_options_fields'].includes(key)){

                    if(config.record[key]) {
                        let option = {
                            xtype: 'textfield',
                            columnWidth: .5,
                            fieldLabel: config.record[key + '.caption'] || _('ms2_frontend_' + key) || key,
                            name: 'option-' + key,
                            anchor: '100%',
                            allowBlank: true
                        }

                        if(typeof(config.record[key]) == 'object') {

                            // Подключаем платные опции
                            var type = config.record[key + '.type'];
                            if(type && ['radiogroups', 'checkboxgroups'].includes(type)) {
                                var properties = JSON.parse(config.record[key + '.properties']);
                                var store = properties.values;

                                if(store.length) {
                                    if(type == 'radiogroups') {
                                        store.unshift('');
                                        option.xtype = 'modx-combo';
                                        option.store = store;
                                        option.listeners = {
                                            select: {
                                                fn: function() {
                                                    this.getPrice(config);
                                                },
                                                scope: this
                                            }
                                        };
                                    } else {
                                        option.columnWidth = 1;
                                        option.xtype = 'checkboxgroup';
                                        option.items = [];
                                        option.columns = 4;
                                        store.forEach((value,idx) => {
                                            option.items.push({
                                                // xtype: 'xcheckbox',
                                                boxLabel: value,
                                                id: config.id + '-' + key + '-' + idx,
                                                name: 'option-' + key + '[]',
                                                inputValue: value,
                                                checked: options[key].includes(value),
                                                listeners: {
                                                    check: {
                                                        fn: function() {
                                                            this.getPrice(config);
                                                        },
                                                        scope: this
                                                    }
                                                }
                                            })
                                        });
                                    }
                                }

                            } else {
                                if(config.record[key] && config.record[key].length) {
                                    option.xtype = 'modx-combo';
                                    option.store = config.record[key];
                                    option.listeners = {
                                        select: {
                                            fn: function() {
                                                this.getPrice(config);
                                            },
                                            scope: this
                                        }
                                    };
                                }
                            }

                        }
                        all.push(option);
                    }



                }
            }

            var addx = function (w1, w2) {
                if (!w1) {
                    w1 = .5;
                }
                if (!w2) {
                    w2 = .5;
                }
                return {
                    layout: 'column',
                    defaults: {msgTarget: 'under', border: false},
                    items: [
                        {columnWidth: +w1.toFixed(1), layout: 'form', items: []},
                        {columnWidth: +w2.toFixed(1), layout: 'form', items: []}
                    ]
                };
            };

            var column = 0;
            var index = 0;
            var idx = -1;

            if (all.length > 0) {
                for (i = 0; i < all.length; i++) {

                    if(all[i]['columnWidth'] == 1) {
                        column = 0;
                        index = 0;
                        idx++;

                        all[i].anchor = '99.5%';
                        all[i].msgTarget = 'under';
                        fields.push(all[i]);
                    } else {
                        if (!column) {
                            fields.push(addx());
                            column = 1;
                            index = 0;
                            idx++;
                        }
                        fields[idx].items[index].items.push(all[i]);
                        if(++index > 1) {
                            column = 0;
                            index = 0;
                        }
                    }
                }
            }
        }

        return {
            xtype: 'fieldset',
            title: _('ms2_product_options'),
            layout: 'form',
            style: 'padding:15px 5px;',
            defaults: {msgTarget: 'under', border: false},
            items: fields
        };
    },


    getPrice: function(config) {
        if(showLog) console.log('[getPrice]:config', config);
        let form = document.getElementById('minishop2-window-orderproduct-update').querySelector('form');
        let count = +form.querySelector('[name="count"]').value;

        let data = this.getProductOptions(config);
        this.setProductOptions(data);
        if(showLog) console.log('[getPrice]:data', data);

        MODx.Ajax.request({
            url: msOrderFields.config.url,
            params: {
                action: 'mgr/product/getprice',
                order_id: config.record.order_id,
                product_id: config.record.product_id || config.record.id,
                count: count,
                options: JSON.stringify(data),
            },
            listeners: {
                success: {
                    fn: function (response) {
                        if(showLog) console.log('[getPrice]:success', response);
                        var w = Ext.getCmp('minishop2-window-orderproduct-update');
                        w.setValues(response.object);
                    },
                    scope: this
                },
                failure: {
                    fn: function (response) {
                        if(showLog) console.log('[getPrice]:error', response);
                        if(response.message) {
                            MODx.msg.alert(_('error'), response.message);
                        }
                    },
                    scope: this
                }
            }
        });
    },

    getProductOptions: function (config) {
        let form = document.getElementById('minishop2-window-orderproduct-update').querySelector('form');
        let data = {};
        let options = {};
        if(config.record.options) {
            options = JSON.parse(config.record.options);
        } else {
            miniShop2.config['order_product_options_fields'].forEach(function (key){
                options[key] = '';
            });
        }

        for(key in options) {
            let option = form.querySelector('[name="option-'+key+'"]');
            if(option) {
                data[key] = option.value;
            } else {
                let optionCheck = form.querySelectorAll('[name="option-'+key+'[]"]');
                if(optionCheck) {
                    data[key] = [];
                    [].forEach.call(optionCheck, function(option){
                        if(option.checked) {
                            data[key].push(option.value);
                        }
                    });
                }
            }
        }

        return data;
    },

    setProductOptions: function (options) {
        let form = document.getElementById('minishop2-window-orderproduct-update').querySelector('form');
        if(form) {
            form.querySelector('[name="options"]').value = JSON.stringify(options);
        }
    }

});